/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.util.Map;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.BaseSerializerFactory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.MapSerializer;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleVersionArtifactIdentifierSerializer
implements Serializer<ModuleComponentArtifactIdentifier> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();
    private final MapSerializer<String, String> attributesSerializer = new MapSerializer(BaseSerializerFactory.STRING_SERIALIZER, BaseSerializerFactory.STRING_SERIALIZER);

    public void write(Encoder encoder, ModuleComponentArtifactIdentifier value) throws Exception {
        DefaultModuleComponentArtifactIdentifier artifact = (DefaultModuleComponentArtifactIdentifier)value;
        this.componentIdentifierSerializer.write(encoder, (ComponentIdentifier)artifact.getComponentIdentifier());
        IvyArtifactName ivyArtifactName = artifact.getName();
        encoder.writeString((CharSequence)ivyArtifactName.getName());
        encoder.writeString((CharSequence)ivyArtifactName.getType());
        encoder.writeNullableString((CharSequence)ivyArtifactName.getExtension());
        this.attributesSerializer.write(encoder, ivyArtifactName.getAttributes());
    }

    public ModuleComponentArtifactIdentifier read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        String artifactName = decoder.readString();
        String type = decoder.readString();
        String extension = decoder.readNullableString();
        Map attributes = this.attributesSerializer.read(decoder);
        return new DefaultModuleComponentArtifactIdentifier(componentIdentifier, artifactName, type, extension, attributes);
    }
}

