/*! grafana - v3.0.4 - 2016-06-01
 * Copyright (c) 2016 Torkel Ödegaard; Licensed Apache-2.0 */

define(["../mocks/dashboard-mock","./helpers","moment","app/features/templating/templateValuesSrv"],function(a,b,c){"use strict";describe("templateValuesSrv",function(){function a(a,b){describe(a,function(){var a={};a.setup=function(b){a.setupFn=b},beforeEach(function(){a.setupFn();var b={};b.metricFindQuery=sinon.stub().returns(d.$q.when(a.queryResult)),d.datasourceSrv.get=sinon.stub().returns(d.$q.when(b)),d.datasourceSrv.getMetricSources=sinon.stub().returns(a.metricSources),d.service.updateOptions(a.variable),d.$rootScope.$digest()}),b(a)})}var d=new b.ServiceTestContext;beforeEach(module("grafana.services")),beforeEach(d.providePhase(["datasourceSrv","timeSrv","templateSrv","$location"])),beforeEach(d.createService("templateValuesSrv")),describe("update interval variable options",function(){var a={type:"interval",query:"auto,1s,2h,5h,1d",name:"test"};beforeEach(function(){d.service.updateOptions(a)}),it("should update options array",function(){expect(a.options.length).to.be(5),expect(a.options[1].text).to.be("1s"),expect(a.options[1].value).to.be("1s")})}),describe("when template variable is present in url",function(){var a={name:"apps",current:{text:"test",value:"test"},options:[{text:"test",value:"test"}]};beforeEach(function(b){var c={templating:{list:[a]}},e={};e["var-apps"]="new",d.$location.search=sinon.stub().returns(e),d.service.init(c).then(function(){b()}),d.$rootScope.$digest()}),it("should update current value",function(){expect(a.current.value).to.be("new"),expect(a.current.text).to.be("new")})}),describe("when template variable is present in url multiple times",function(){var a={name:"apps",multi:!0,current:{text:"val1",value:"val1"},options:[{text:"val1",value:"val1"},{text:"val2",value:"val2"},{text:"val3",value:"val3",selected:!0}]};beforeEach(function(b){var c={templating:{list:[a]}},e={};e["var-apps"]=["val2","val1"],d.$location.search=sinon.stub().returns(e),d.service.init(c).then(function(){b()}),d.$rootScope.$digest()}),it("should update current value",function(){expect(a.current.value.length).to.be(2),expect(a.current.value[0]).to.be("val2"),expect(a.current.value[1]).to.be("val1"),expect(a.current.text).to.be("val2 + val1"),expect(a.options[0].selected).to.be(!0),expect(a.options[1].selected).to.be(!0)}),it("should set options that are not in value to selected false",function(){expect(a.options[2].selected).to.be(!1)})}),a("interval variable without auto",function(a){a.setup(function(){a.variable={type:"interval",query:"1s,2h,5h,1d",name:"test"}}),it("should update options array",function(){expect(a.variable.options.length).to.be(4),expect(a.variable.options[0].text).to.be("1s"),expect(a.variable.options[0].value).to.be("1s")})}),a("query variable with empty current object and refresh",function(a){a.setup(function(){a.variable={type:"query",query:"",name:"test",current:{}},a.queryResult=[{text:"backend1"},{text:"backend2"}]}),it("should set current value to first option",function(){expect(a.variable.options.length).to.be(2),expect(a.variable.current.value).to.be("backend1")})}),a("query variable with multi select and new options does not contain some selected values",function(a){a.setup(function(){a.variable={type:"query",query:"",name:"test",current:{value:["val1","val2","val3"],text:"val1 + val2 + val3"}},a.queryResult=[{text:"val2"},{text:"val3"}]}),it("should update current value",function(){expect(a.variable.current.value).to.eql(["val2","val3"]),expect(a.variable.current.text).to.eql("val2 + val3")})}),a("query variable with multi select and new options does not contain any selected values",function(a){a.setup(function(){a.variable={type:"query",query:"",name:"test",current:{value:["val1","val2","val3"],text:"val1 + val2 + val3"}},a.queryResult=[{text:"val5"},{text:"val6"}]}),it("should update current value with first one",function(){expect(a.variable.current.value).to.eql("val5"),expect(a.variable.current.text).to.eql("val5")})}),a("query variable with numeric results",function(a){a.setup(function(){a.variable={type:"query",query:"",name:"test",current:{}},a.queryResult=[{text:12,value:12}]}),it("should set current value to first option",function(){expect(a.variable.current.value).to.be("12"),expect(a.variable.options[0].value).to.be("12"),expect(a.variable.options[0].text).to.be("12")})}),a("interval variable without auto",function(a){a.setup(function(){a.variable={type:"interval",query:"1s,2h,5h,1d",name:"test"}}),it("should update options array",function(){expect(a.variable.options.length).to.be(4),expect(a.variable.options[0].text).to.be("1s"),expect(a.variable.options[0].value).to.be("1s")})}),a("interval variable with auto",function(a){a.setup(function(){a.variable={type:"interval",query:"1s,2h,5h,1d",name:"test",auto:!0,auto_count:10};var b={from:c(new Date).subtract(7,"days").toDate(),to:new Date};d.timeSrv.timeRange=sinon.stub().returns(b),d.templateSrv.setGrafanaVariable=sinon.spy()}),it("should update options array",function(){expect(a.variable.options.length).to.be(5),expect(a.variable.options[0].text).to.be("auto"),expect(a.variable.options[0].value).to.be("$__auto_interval")}),it("should set $__auto_interval",function(){var a=d.templateSrv.setGrafanaVariable.getCall(0);expect(a.args[0]).to.be("$__auto_interval"),expect(a.args[1]).to.be("12h")})}),a("update custom variable",function(a){a.setup(function(){a.variable={type:"custom",query:"hej, hop, asd",name:"test"}}),it("should update options array",function(){expect(a.variable.options.length).to.be(3),expect(a.variable.options[0].text).to.be("hej"),expect(a.variable.options[1].value).to.be("hop")}),it("should set $__auto_interval",function(){var a=d.templateSrv.setGrafanaVariable.getCall(0);expect(a.args[0]).to.be("$__auto_interval"),expect(a.args[1]).to.be("12h")})}),a("basic query variable",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.queryResult=[{text:"backend1"},{text:"backend2"}]}),it("should update options array",function(){expect(a.variable.options.length).to.be(2),expect(a.variable.options[0].text).to.be("backend1"),expect(a.variable.options[0].value).to.be("backend1"),expect(a.variable.options[1].value).to.be("backend2")}),it("should select first option as value",function(){expect(a.variable.current.value).to.be("backend1")})}),a("and existing value still exists in options",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.variable.current={value:"backend2",text:"backend2"},a.queryResult=[{text:"backend1"},{text:"backend2"}]}),it("should keep variable value",function(){expect(a.variable.current.text).to.be("backend2")})}),a("and regex pattern exists",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.variable.regex="/apps.*(backend_[0-9]+)/",a.queryResult=[{text:"apps.backend.backend_01.counters.req"},{text:"apps.backend.backend_02.counters.req"}]}),it("should extract and use match group",function(){expect(a.variable.options[0].value).to.be("backend_01")})}),a("and regex pattern exists and no match",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.variable.regex="/apps.*(backendasd[0-9]+)/",a.queryResult=[{text:"apps.backend.backend_01.counters.req"},{text:"apps.backend.backend_02.counters.req"}]}),it("should not add non matching items, None option should be added instead",function(){expect(a.variable.options.length).to.be(1),expect(a.variable.options[0].isNone).to.be(!0)})}),a("regex pattern without slashes",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.variable.regex="backend_01",a.queryResult=[{text:"apps.backend.backend_01.counters.req"},{text:"apps.backend.backend_02.counters.req"}]}),it("should return matches options",function(){expect(a.variable.options.length).to.be(1)})}),a("regex pattern remove duplicates",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test"},a.variable.regex="backend_01",a.queryResult=[{text:"apps.backend.backend_01.counters.req"},{text:"apps.backend.backend_01.counters.req"}]}),it("should return matches options",function(){expect(a.variable.options.length).to.be(1)})}),a("with include All",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test",includeAll:!0},a.queryResult=[{text:"backend1"},{text:"backend2"},{text:"backend3"}]}),it("should add All option",function(){expect(a.variable.options[0].text).to.be("All"),expect(a.variable.options[0].value).to.be("$__all")})}),a("with include all and custom value",function(a){a.setup(function(){a.variable={type:"query",query:"apps.*",name:"test",includeAll:!0,allValue:"*"},a.queryResult=[{text:"backend1"},{text:"backend2"},{text:"backend3"}]}),it("should add All option with custom value",function(){expect(a.variable.options[0].value).to.be("$__all")})}),a("datasource variable with regex filter",function(a){a.setup(function(){a.variable={type:"datasource",query:"graphite",name:"test",current:{value:"backend4_pee",text:"backend4_pee"},regex:"/pee$/"},a.metricSources=[{name:"backend1",meta:{id:"influx"}},{name:"backend2_pee",meta:{id:"graphite"}},{name:"backend3",meta:{id:"graphite"}},{name:"backend4_pee",meta:{id:"graphite"}}]}),it("should set only contain graphite ds and filtered using regex",function(){expect(a.variable.options.length).to.be(2),expect(a.variable.options[0].value).to.be("backend2_pee"),expect(a.variable.options[1].value).to.be("backend4_pee")}),it("should keep current value if available",function(){expect(a.variable.current.value).to.be("backend4_pee")})})})});