/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.JC;

public class JcampdxReader
extends MolReader
implements JmolJDXMOLReader {
    private int selectedModel;
    private JmolJDXMOLParser mpr;
    private String acdMolFile;
    private int nPeaks;
    private Lst<String[]> acdAssignments;
    private String title;
    private String nucleus = "";
    private String type;
    private Lst<String> peakData = new Lst();
    private String allTypes;

    @Override
    public void initializeReader() throws Exception {
        this.vwr.setBooleanProperty("_JSpecView".toLowerCase(), true);
        if (this.isTrajectory) {
            Logger.warn("TRAJECTORY keyword ignored");
            this.isTrajectory = false;
        }
        if (this.reverseModels) {
            Logger.warn("REVERSE keyword ignored");
            this.reverseModels = false;
        }
        this.selectedModel = this.desiredModelNumber;
        this.desiredModelNumber = Integer.MIN_VALUE;
        if (!this.checkFilterKey("NOSYNC")) {
            this.addJmolScript("sync on");
        }
    }

    @Override
    public boolean checkLine() throws Exception {
        int pt;
        int i = this.line.indexOf("=");
        if (i < 0 || !this.line.startsWith("##")) {
            return true;
        }
        String label = PT.replaceAllCharacters(this.line.substring(0, i).trim(), " ", "").toUpperCase();
        if (label.length() > 12) {
            label = label.substring(0, 12);
        }
        if ((pt = "##$MODELS   ##$PEAKS    ##$SIGNALS  ##$MOLFILE  ##NPOINTS   ##TITLE     ##PEAKASSIGN##$UVIR_ASSI##$MS_FRAGME##.OBSERVENU##DATATYPE  ".indexOf(label)) < 0) {
            return true;
        }
        if (this.mpr == null) {
            this.mpr = ((JmolJDXMOLParser)Interface.getOption("jsv.JDXMOLParser", this.vwr, "file")).set(this, this.filePath, this.htParams);
        }
        String value = this.line.substring(i + 1).trim();
        this.mpr.setLine(value);
        switch (pt) {
            case 0: {
                this.mpr.readModels();
                break;
            }
            case 12: 
            case 24: {
                this.mpr.readPeaks(pt == 24, -1);
                break;
            }
            case 36: {
                this.acdMolFile = this.mpr.readACDMolFile();
                this.processModelData(this.acdMolFile, this.title + " (assigned)", "MOL", "mol", "", 0.01f, Float.NaN, true);
                if (this.asc.errorMessage == null) break;
                this.continuing = false;
                return false;
            }
            case 48: {
                this.nPeaks = PT.parseInt(value);
                break;
            }
            case 60: {
                this.title = PT.split(value, "$$")[0].trim();
                break;
            }
            case 72: 
            case 84: 
            case 96: {
                this.acdAssignments = this.mpr.readACDAssignments(this.nPeaks, pt == 72);
                break;
            }
            case 108: {
                this.nucleus = value.substring(1);
                break;
            }
            case 120: {
                this.type = value;
                pt = this.type.indexOf(" ");
                if (pt < 0) break;
                this.type = this.type.substring(0, pt);
            }
        }
        return true;
    }

    @Override
    public void finalizeSubclassReader() throws Exception {
        if (this.mpr != null) {
            this.processPeakData();
        }
        this.finalizeReaderMR();
    }

    @Override
    public void processModelData(String data, String id, String type, String base, String last, float modelScale, float vibScale, boolean isFirst) throws Exception {
        int model0 = this.asc.iSet;
        AtomSetCollection model = null;
        Object ret = SmarterJmolAdapter.staticGetAtomSetCollectionReader(this.filePath, type, Rdr.getBR(data), this.htParams);
        if (ret instanceof String) {
            Logger.warn("" + ret);
            if (((String)ret).startsWith(JC.READER_NOT_FOUND)) {
                this.asc.errorMessage = (String)ret;
            }
        } else if ((ret = SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)ret)) instanceof String) {
            Logger.warn("" + ret);
        } else {
            int i;
            int ibase;
            model = (AtomSetCollection)ret;
            String baseModel = base;
            if (baseModel.length() == 0) {
                baseModel = last;
            }
            if (baseModel.length() != 0 && (ibase = this.findModelById(baseModel)) >= 0) {
                this.asc.setModelInfoForSet("jdxModelID", baseModel, ibase);
                i = model.atomSetCount;
                while (--i >= 0) {
                    model.setModelInfoForSet("jdxBaseModel", baseModel, i);
                }
                if (model.bondCount == 0) {
                    this.setBonding(model, ibase);
                }
            }
            if (!Float.isNaN(vibScale)) {
                Logger.info("JcampdxReader applying vibration scaling of " + vibScale + " to " + model.ac + " atoms");
                Atom[] atoms = model.atoms;
                i = model.ac;
                while (--i >= 0) {
                    if (atoms[i].vib == null || Float.isNaN(atoms[i].vib.z)) continue;
                    atoms[i].vib.scale(vibScale);
                }
            }
            if (!Float.isNaN(modelScale)) {
                Logger.info("JcampdxReader applying model scaling of " + modelScale + " to " + model.ac + " atoms");
                Atom[] atoms = model.atoms;
                i = model.ac;
                while (--i >= 0) {
                    atoms[i].scale(modelScale);
                }
            }
            Logger.info("jdx model=" + id + " type=" + model.fileTypeName);
            this.asc.appendAtomSetCollection(-1, model);
        }
        this.updateModelIDs(id, model0, isFirst);
    }

    private void setBonding(AtomSetCollection a, int ibase) {
        int n = a.ac;
        int n0 = this.asc.getAtomSetAtomCount(ibase);
        if (n % n0 != 0) {
            Logger.warn("atom count in secondary model (" + n + ") is not a multiple of " + n0 + " -- bonding ignored");
            return;
        }
        Bond[] bonds = this.asc.bonds;
        int b0 = 0;
        for (int i = 0; i < ibase; ++i) {
            b0 += this.asc.getAtomSetBondCount(i);
        }
        int b1 = b0 + this.asc.getAtomSetBondCount(ibase);
        int ii0 = this.asc.getAtomSetAtomIndex(ibase);
        int nModels = a.atomSetCount;
        for (int j = 0; j < nModels; ++j) {
            int i0 = a.getAtomSetAtomIndex(j) - ii0;
            if (a.getAtomSetAtomCount(j) != n0) {
                Logger.warn("atom set atom count in secondary model (" + a.getAtomSetAtomCount(j) + ") is not equal to " + n0 + " -- bonding ignored");
                return;
            }
            for (int i = b0; i < b1; ++i) {
                a.addNewBondWithOrder(bonds[i].atomIndex1 + i0, bonds[i].atomIndex2 + i0, bonds[i].order);
            }
        }
    }

    private void updateModelIDs(String id, int model0, boolean isFirst) {
        int n = this.asc.atomSetCount;
        if (isFirst && n == model0 + 2) {
            this.asc.setCurrentModelInfo("modelID", id);
            return;
        }
        int pt = 0;
        int i = model0;
        while (++i < n) {
            this.asc.setModelInfoForSet("modelID", id + "." + ++pt, i);
        }
    }

    @Override
    public void addPeakData(String info) {
        this.peakData.addLast(info);
    }

    private void processPeakData() {
        int n;
        if (this.acdAssignments != null) {
            try {
                this.mpr.setACDAssignments(this.title, this.nucleus + this.type, 0, this.acdAssignments, this.acdMolFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((n = this.peakData.size()) == 0) {
            return;
        }
        BS bsModels = new BS();
        boolean havePeaks = n > 0;
        for (int p = 0; p < n; ++p) {
            String s;
            this.line = (String)this.peakData.get(p);
            String type = this.mpr.getAttribute(this.line, "type");
            String id = this.mpr.getAttribute(this.line, "model");
            int i = this.findModelById(id);
            if (i < 0) {
                Logger.warn("cannot find model " + id + " required for " + this.line);
                continue;
            }
            this.addType(i, type);
            String title = type + ": " + this.mpr.getAttribute(this.line, "title");
            String key = "jdxAtomSelect_" + this.mpr.getAttribute(this.line, "type");
            bsModels.set(i);
            if (this.mpr.getAttribute(this.line, "atoms").length() != 0) {
                this.processPeakSelectAtom(i, key, this.line);
                s = type + ": ";
            } else {
                s = this.processPeakSelectModel(i, title) ? "model: " : "ignored: ";
            }
            Logger.info(s + this.line);
        }
        int i = n = this.asc.atomSetCount;
        while (--i >= 0) {
            String id = (String)this.asc.getAtomSetAuxiliaryInfoValue(i, "modelID");
            if (!havePeaks || bsModels.get(i) || id.indexOf(".") < 0) continue;
            this.removeAtomSet(i);
            --n;
        }
        if (this.selectedModel == Integer.MIN_VALUE) {
            if (this.allTypes != null) {
                this.appendLoadNote(this.allTypes);
            }
        } else {
            if (this.selectedModel == 0) {
                this.selectedModel = n - 1;
            }
            i = this.asc.atomSetCount;
            while (--i >= 0) {
                if (i + 1 == this.selectedModel) continue;
                this.removeAtomSet(i);
            }
            if (n > 0) {
                this.appendLoadNote((String)this.asc.getAtomSetAuxiliaryInfoValue(0, "name"));
            }
        }
        i = this.asc.atomSetCount;
        while (--i >= 0) {
            this.asc.setAtomSetNumber(i, i + 1);
        }
        this.asc.centralize();
    }

    private int findModelById(String modelID) {
        int i = this.asc.atomSetCount;
        while (--i >= 0) {
            String id = (String)this.asc.getAtomSetAuxiliaryInfoValue(i, "modelID");
            if (!modelID.equals(id)) continue;
            return i;
        }
        return -1;
    }

    private void addType(int imodel, String type) {
        String types = this.addTypeStr((String)this.asc.getAtomSetAuxiliaryInfoValue(imodel, "spectrumTypes"), type);
        if (types == null) {
            return;
        }
        this.asc.setModelInfoForSet("spectrumTypes", types, imodel);
        String s = this.addTypeStr(this.allTypes, type);
        if (s != null) {
            this.allTypes = s;
        }
    }

    private String addTypeStr(String types, String type) {
        if (types != null && types.contains(type)) {
            return null;
        }
        types = types == null ? "" : types + ",";
        return types + type;
    }

    private void processPeakSelectAtom(int i, String key, String data) {
        Lst<String> peaks = (Lst<String>)this.asc.getAtomSetAuxiliaryInfoValue(i, key);
        if (peaks == null) {
            peaks = new Lst<String>();
            this.asc.setModelInfoForSet(key, peaks, i);
        }
        peaks.addLast(data);
    }

    private boolean processPeakSelectModel(int i, String title) {
        if (this.asc.getAtomSetAuxiliaryInfoValue(i, "jdxModelSelect") != null) {
            return false;
        }
        this.asc.setModelInfoForSet("name", title, i);
        this.asc.setModelInfoForSet("jdxModelSelect", this.line, i);
        return true;
    }

    @Override
    public void setSpectrumPeaks(int nH, String piUnitsX, String piUnitsY) {
    }

    private void removeAtomSet(int imodel) {
        int i;
        if (this.asc.bsAtoms == null) {
            this.asc.bsAtoms = BSUtil.newBitSet2(0, this.asc.ac);
        }
        int i0 = this.asc.atomSetAtomIndexes[imodel];
        int nAtoms = this.asc.atomSetAtomCounts[imodel];
        int i1 = i0 + nAtoms;
        this.asc.bsAtoms.clearBits(i0, i1);
        for (i = i1; i < this.asc.ac; ++i) {
            --this.asc.atoms[i].atomSetIndex;
        }
        for (i = imodel + 1; i < this.asc.atomSetCount; ++i) {
            this.asc.atomSetAuxiliaryInfo[i - 1] = this.asc.atomSetAuxiliaryInfo[i];
            this.asc.atomSetAtomIndexes[i - 1] = this.asc.atomSetAtomIndexes[i];
            this.asc.atomSetBondCounts[i - 1] = this.asc.atomSetBondCounts[i];
            this.asc.atomSetAtomCounts[i - 1] = this.asc.atomSetAtomCounts[i];
            this.asc.atomSetNumbers[i - 1] = this.asc.atomSetNumbers[i];
        }
        for (i = 0; i < this.asc.bondCount; ++i) {
            this.asc.bonds[i].atomSetIndex = this.asc.atoms[this.asc.bonds[i].atomIndex1].atomSetIndex;
        }
        this.asc.atomSetAuxiliaryInfo[--this.asc.atomSetCount] = null;
        int n = 0;
        for (int i2 = 0; i2 < this.asc.structureCount; ++i2) {
            Structure s = this.asc.structures[i2];
            if (s.modelStartEnd[0] != imodel || s.modelStartEnd[1] != imodel) continue;
            this.asc.structures[i2] = null;
            ++n;
        }
        if (n > 0) {
            Structure[] ss = new Structure[this.asc.structureCount - n];
            int pt = 0;
            for (int i3 = 0; i3 < this.asc.structureCount; ++i3) {
                if (this.asc.structures[i3] == null) continue;
                ss[pt++] = this.asc.structures[i3];
            }
            this.asc.structures = ss;
        }
    }
}

