/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.disk.block;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDisk;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskCacheAttributes;
import org.apache.commons.jcs.auxiliary.disk.block.BlockDiskKeyStore;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.behavior.IElementSerializer;
import org.apache.commons.jcs.engine.behavior.IRequireScheduler;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BlockDiskCache<K, V>
extends AbstractDiskCache<K, V>
implements IRequireScheduler {
    private static final Log log = LogFactory.getLog(BlockDiskCache.class);
    private final String logCacheName;
    private final String fileName;
    private BlockDisk dataFile;
    private final BlockDiskCacheAttributes blockDiskCacheAttributes;
    private final File rootDirectory;
    private BlockDiskKeyStore<K> keyStore;
    private final ReentrantReadWriteLock storageLock = new ReentrantReadWriteLock();
    private ScheduledFuture<?> future;

    public BlockDiskCache(BlockDiskCacheAttributes blockDiskCacheAttributes) {
        this(blockDiskCacheAttributes, null);
    }

    public BlockDiskCache(BlockDiskCacheAttributes blockDiskCacheAttributes, IElementSerializer iElementSerializer) {
        super(blockDiskCacheAttributes);
        this.setElementSerializer(iElementSerializer);
        this.blockDiskCacheAttributes = blockDiskCacheAttributes;
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Constructing BlockDiskCache with attributes " + blockDiskCacheAttributes);
        }
        this.fileName = this.getCacheName().replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        this.rootDirectory = blockDiskCacheAttributes.getDiskPath();
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Cache file root directory: [" + this.rootDirectory + "]");
        }
        try {
            this.dataFile = this.blockDiskCacheAttributes.getBlockSizeBytes() > 0 ? new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.blockDiskCacheAttributes.getBlockSizeBytes(), this.getElementSerializer()) : new BlockDisk(new File(this.rootDirectory, this.fileName + ".data"), this.getElementSerializer());
            this.keyStore = new BlockDiskKeyStore(this.blockDiskCacheAttributes, this);
            boolean bl = this.verifyDisk();
            if (this.keyStore.size() == 0 || !bl) {
                this.reset();
            }
            this.setAlive(true);
            if (log.isInfoEnabled()) {
                log.info(this.logCacheName + "Block Disk Cache is alive.");
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and root directory: " + this.rootDirectory, iOException);
        }
    }

    @Override
    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        if (this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds() > 0L) {
            this.future = scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    BlockDiskCache.this.keyStore.saveKeys();
                }
            }, this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), this.blockDiskCacheAttributes.getKeyPersistenceIntervalSeconds(), TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifyDisk() {
        boolean bl = false;
        this.storageLock.readLock().lock();
        try {
            int n = 100;
            Iterator<Map.Entry<K, int[]>> iterator = this.keyStore.entrySet().iterator();
            for (int i = 0; iterator.hasNext() && i < n; ++i) {
                Map.Entry<K, int[]> entry = iterator.next();
                Object t = this.dataFile.read(entry.getValue());
                if (t != null) continue;
                throw new Exception(this.logCacheName + "Couldn't find data for key [" + entry.getKey() + "]");
            }
            bl = true;
        }
        catch (Exception exception) {
            log.warn(this.logCacheName + "Problem verifying disk.  Message [" + exception.getMessage() + "]");
            bl = false;
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> getKeySet() throws IOException {
        HashSet<K> hashSet = new HashSet<K>();
        this.storageLock.readLock().lock();
        try {
            hashSet.addAll(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, ICacheElement<K, V>> processGetMatching(String string) {
        HashMap hashMap = new HashMap();
        HashSet<K> hashSet = null;
        this.storageLock.readLock().lock();
        try {
            hashSet = new HashSet<K>(this.keyStore.keySet());
        }
        finally {
            this.storageLock.readLock().unlock();
        }
        Set set = this.getKeyMatcher().getMatchingKeysFromArray(string, hashSet);
        for (Object k : set) {
            ICacheElement iCacheElement = this.processGet(k);
            if (iCacheElement == null) continue;
            hashMap.put(k, iCacheElement);
        }
        return hashMap;
    }

    @Override
    public int getSize() {
        return this.keyStore.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ICacheElement<K, V> processGet(K k) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive so returning null for key = " + k);
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Trying to get from disk: " + k);
        }
        ICacheElement iCacheElement = null;
        try {
            this.storageLock.readLock().lock();
            try {
                int[] nArray = this.keyStore.get(k);
                if (nArray != null) {
                    iCacheElement = (ICacheElement)this.dataFile.read(nArray);
                }
            }
            finally {
                this.storageLock.readLock().unlock();
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure getting from disk--IOException, key = " + k, iOException);
            this.reset();
        }
        catch (Exception exception) {
            log.error(this.logCacheName + "Failure getting from disk, key = " + k, exception);
        }
        return iCacheElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processUpdate(ICacheElement<K, V> iCacheElement) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive; aborting put of key = " + iCacheElement.getKey());
            }
            return;
        }
        int[] nArray = null;
        this.storageLock.writeLock().lock();
        try {
            nArray = this.keyStore.get(iCacheElement.getKey());
            if (nArray != null) {
                this.dataFile.freeBlocks(nArray);
            }
            int[] nArray2 = this.dataFile.write(iCacheElement);
            this.keyStore.put(iCacheElement.getKey(), nArray2);
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "Put to file [" + this.fileName + "] key [" + iCacheElement.getKey() + "]");
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure updating element, key: " + iCacheElement.getKey() + " old: " + Arrays.toString(nArray), iOException);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isDebugEnabled()) {
            log.debug(this.logCacheName + "Storing element on disk, key: " + iCacheElement.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processRemove(K k) {
        if (!this.isAlive()) {
            if (log.isDebugEnabled()) {
                log.debug(this.logCacheName + "No longer alive so returning false for key = " + k);
            }
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        this.storageLock.writeLock().lock();
        try {
            if (k instanceof String && k.toString().endsWith(":")) {
                Iterator<Map.Entry<K, int[]>> iterator = this.keyStore.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, int[]> entry = iterator.next();
                    K k2 = entry.getKey();
                    if (!(k2 instanceof String) || !k2.toString().startsWith(k.toString())) continue;
                    int[] nArray = entry.getValue();
                    this.dataFile.freeBlocks(nArray);
                    iterator.remove();
                    bl2 = true;
                }
            } else if (k instanceof GroupAttrName && ((GroupAttrName)k).attrName == null) {
                Iterator<Map.Entry<K, int[]>> iterator = this.keyStore.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, int[]> entry = iterator.next();
                    K k3 = entry.getKey();
                    if (!(k3 instanceof GroupAttrName) || !((GroupAttrName)k3).groupId.equals(((GroupAttrName)k).groupId)) continue;
                    int[] nArray = entry.getValue();
                    this.dataFile.freeBlocks(nArray);
                    iterator.remove();
                    bl2 = true;
                }
            } else {
                int[] nArray = this.keyStore.remove(k);
                boolean bl3 = bl2 = nArray != null;
                if (bl2) {
                    this.dataFile.freeBlocks(nArray);
                }
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Disk removal: Removed from key hash, key [" + k + "] removed = " + bl2);
                }
            }
        }
        catch (Exception exception) {
            log.error(this.logCacheName + "Problem removing element.", exception);
            bl = true;
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (bl) {
            this.reset();
        }
        return bl2;
    }

    @Override
    protected void processRemoveAll() {
        this.reset();
    }

    @Override
    public void processDispose() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    BlockDiskCache.this.disposeInternal();
                }
                catch (InterruptedException interruptedException) {
                    log.warn("Interrupted while diposing.");
                }
            }
        };
        Thread thread = new Thread(runnable, "BlockDiskCache-DisposalThread");
        thread.start();
        try {
            thread.join(60000L);
        }
        catch (InterruptedException interruptedException) {
            log.error(this.logCacheName + "Interrupted while waiting for disposal thread to finish.", interruptedException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disposeInternal() throws InterruptedException {
        if (!this.isAlive()) {
            log.error(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName);
            return;
        }
        this.storageLock.writeLock().lock();
        try {
            this.setAlive(false);
            this.keyStore.saveKeys();
            if (this.future != null) {
                this.future.cancel(true);
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug(this.logCacheName + "Closing files, base filename: " + this.fileName);
                }
                this.dataFile.close();
            }
            catch (IOException iOException) {
                log.error(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName, iOException);
            }
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
        if (log.isInfoEnabled()) {
            log.info(this.logCacheName + "Shutdown complete.");
        }
    }

    @Override
    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.blockDiskCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn(this.logCacheName + "Resetting cache");
        }
        try {
            this.storageLock.writeLock().lock();
            this.keyStore.reset();
            if (this.dataFile != null) {
                this.dataFile.reset();
            }
        }
        catch (IOException iOException) {
            log.error(this.logCacheName + "Failure resetting state", iOException);
        }
        finally {
            this.storageLock.writeLock().unlock();
        }
    }

    protected void freeBlocks(int[] nArray) {
        this.dataFile.freeBlocks(nArray);
    }

    @Override
    public String getStats() {
        return this.getStatistics().toString();
    }

    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Block Disk Cache");
        ArrayList arrayList = new ArrayList();
        arrayList.add(new StatElement<Boolean>("Is Alive", this.isAlive()));
        arrayList.add(new StatElement<Integer>("Key Map Size", this.keyStore.size()));
        if (this.dataFile != null) {
            try {
                arrayList.add(new StatElement<Long>("Data File Length", this.dataFile.length()));
            }
            catch (IOException iOException) {
                log.error(iOException);
            }
            arrayList.add(new StatElement<Integer>("Block Size Bytes", this.dataFile.getBlockSizeBytes()));
            arrayList.add(new StatElement<Integer>("Number Of Blocks", this.dataFile.getNumberOfBlocks()));
            arrayList.add(new StatElement<Long>("Average Put Size Bytes", this.dataFile.getAveragePutSizeBytes()));
            arrayList.add(new StatElement<Integer>("Empty Blocks", this.dataFile.getEmptyBlocks()));
        }
        IStats iStats = super.getStatistics();
        arrayList.addAll(iStats.getStatElements());
        stats.setStatElements(arrayList);
        return stats;
    }

    @Override
    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }
}

