/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.CustomConfigurator;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.oauth.AbstractAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedure;
import org.openstreetmap.josm.gui.oauth.AuthorizationProcedureComboBox;
import org.openstreetmap.josm.gui.oauth.FullyAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.ManualAuthorizationUI;
import org.openstreetmap.josm.gui.oauth.SemiAutomaticAuthorizationUI;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.WindowGeometry;

public class OAuthAuthorizationWizard
extends JDialog {
    private boolean canceled;
    private final String apiUrl;
    private final AuthorizationProcedureComboBox cbAuthorisationProcedure = new AuthorizationProcedureComboBox();
    private FullyAutomaticAuthorizationUI pnlFullyAutomaticAuthorisationUI;
    private SemiAutomaticAuthorizationUI pnlSemiAutomaticAuthorisationUI;
    private ManualAuthorizationUI pnlManualAuthorisationUI;
    private JScrollPane spAuthorisationProcedureUI;
    private final transient Executor executor;

    public void showDialog() throws UserCancelException {
        this.setVisible(true);
        if (this.isCanceled()) {
            throw new UserCancelException();
        }
        OAuthAccessTokenHolder oAuthAccessTokenHolder = OAuthAccessTokenHolder.getInstance();
        oAuthAccessTokenHolder.setAccessToken(this.getAccessToken());
        oAuthAccessTokenHolder.setSaveToPreferences(this.isSaveAccessTokenToPreferences());
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        AcceptAccessTokenAction acceptAccessTokenAction = new AcceptAccessTokenAction();
        this.pnlFullyAutomaticAuthorisationUI.addPropertyChangeListener(acceptAccessTokenAction);
        this.pnlSemiAutomaticAuthorisationUI.addPropertyChangeListener(acceptAccessTokenAction);
        this.pnlManualAuthorisationUI.addPropertyChangeListener(acceptAccessTokenAction);
        jPanel.add(new SideButton(acceptAccessTokenAction));
        jPanel.add(new SideButton(new CancelAction()));
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"))));
        return jPanel;
    }

    protected JPanel buildHeaderInfoPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        ImageProvider imageProvider = new ImageProvider("oauth", "oauth-logo").setMaxHeight(100);
        JLabel jLabel = new JLabel(imageProvider.get());
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jLabel.setOpaque(true);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html><body>" + I18n.tr("With OAuth you grant JOSM the right to upload map data and GPS tracks on your behalf (<a href=\"{0}\">more info...</a>).", "http://oauth.net/") + "</body></html>");
        htmlPanel.getEditorPane().addHyperlinkListener(new ExternalBrowserLauncher());
        jPanel.add((Component)htmlPanel, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel(I18n.tr("Please select an authorization procedure: ", new Object[0]));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.cbAuthorisationProcedure, gridBagConstraints);
        this.cbAuthorisationProcedure.addItemListener(new AuthorisationProcedureChangeListener());
        jLabel.setLabelFor(this.cbAuthorisationProcedure);
        if (!"https://api.openstreetmap.org/api".equals(this.apiUrl)) {
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            HtmlPanel htmlPanel2 = new HtmlPanel();
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)htmlPanel2.getEditorPane().getEditorKit();
            hTMLEditorKit.getStyleSheet().addRule(".warning-body {background-color:rgb(253,255,221);padding: 10pt; border-color:rgb(128,128,128);border-style: solid;border-width: 1px;}");
            hTMLEditorKit.getStyleSheet().addRule("ol {margin-left: 1cm}");
            htmlPanel2.setText("<html><body><p class=\"warning-body\">" + I18n.tr("<strong>Warning:</strong> Since you are using not the default OSM API, make sure to set an OAuth consumer key and secret in the <i>Advanced OAuth parameters</i>.", new Object[0]) + "</p>" + "</body></html>");
            jPanel.add((Component)htmlPanel2, gridBagConstraints);
        }
        return jPanel;
    }

    protected void refreshAuthorisationProcedurePanel() {
        AuthorizationProcedure authorizationProcedure = (AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem());
        switch (authorizationProcedure) {
            case FULLY_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlFullyAutomaticAuthorisationUI);
                this.pnlFullyAutomaticAuthorisationUI.revalidate();
                break;
            }
            case SEMI_AUTOMATIC: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlSemiAutomaticAuthorisationUI);
                this.pnlSemiAutomaticAuthorisationUI.revalidate();
                break;
            }
            case MANUALLY: {
                this.spAuthorisationProcedureUI.getViewport().setView(this.pnlManualAuthorisationUI);
                this.pnlManualAuthorisationUI.revalidate();
            }
        }
        this.validate();
        this.repaint();
    }

    protected final void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildHeaderInfoPanel(), "North");
        this.setTitle(I18n.tr("Get an Access Token for ''{0}''", this.apiUrl));
        this.setMinimumSize(new Dimension(600, 420));
        this.pnlFullyAutomaticAuthorisationUI = new FullyAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlSemiAutomaticAuthorisationUI = new SemiAutomaticAuthorizationUI(this.apiUrl, this.executor);
        this.pnlManualAuthorisationUI = new ManualAuthorizationUI(this.apiUrl, this.executor);
        this.spAuthorisationProcedureUI = GuiHelper.embedInVerticalScrollPane(new JPanel());
        this.spAuthorisationProcedureUI.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                OAuthAuthorizationWizard.this.spAuthorisationProcedureUI.setBorder(null);
            }
        });
        this.getContentPane().add((Component)this.spAuthorisationProcedureUI, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        this.refreshAuthorisationProcedurePanel();
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
    }

    public OAuthAuthorizationWizard(Component component, String string, Executor executor) {
        super((Window)GuiHelper.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        CheckParameterUtil.ensureParameterNotNull(string, "apiUrl");
        this.apiUrl = string;
        this.executor = executor;
        this.build();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected AbstractAuthorizationUI getCurrentAuthorisationUI() {
        switch ((AuthorizationProcedure)((Object)this.cbAuthorisationProcedure.getSelectedItem())) {
            case FULLY_AUTOMATIC: {
                return this.pnlFullyAutomaticAuthorisationUI;
            }
            case MANUALLY: {
                return this.pnlManualAuthorisationUI;
            }
            case SEMI_AUTOMATIC: {
                return this.pnlSemiAutomaticAuthorisationUI;
            }
        }
        return null;
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentAuthorisationUI().getAccessToken();
    }

    public OAuthParameters getOAuthParameters() {
        return this.getCurrentAuthorisationUI().getOAuthParameters();
    }

    public boolean isSaveAccessTokenToPreferences() {
        return this.getCurrentAuthorisationUI().isSaveAccessTokenToPreferences();
    }

    public void initFromPreferences() {
        Preferences preferences = CustomConfigurator.clonePreferences(Main.pref);
        preferences.put("osm-server.url", this.apiUrl);
        this.pnlFullyAutomaticAuthorisationUI.initFromPreferences(preferences);
        this.pnlSemiAutomaticAuthorisationUI.initFromPreferences(preferences);
        this.pnlManualAuthorisationUI.initFromPreferences(preferences);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(450, 540))).applySafe(this);
            this.initFromPreferences();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    static class ExternalBrowserLauncher
    implements HyperlinkListener {
        ExternalBrowserLauncher() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                OpenBrowser.displayUrl(hyperlinkEvent.getDescription());
            }
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancel();
        }
    }

    class AcceptAccessTokenAction
    extends AbstractAction
    implements PropertyChangeListener {
        AcceptAccessTokenAction() {
            this.putValue("Name", I18n.tr("Accept Access Token", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and accept the Access Token", new Object[0]));
            this.updateEnabledState(null);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OAuthAuthorizationWizard.this.setCanceled(false);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        public final void updateEnabledState(OAuthToken oAuthToken) {
            this.setEnabled(oAuthToken != null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!propertyChangeEvent.getPropertyName().equals(AbstractAuthorizationUI.ACCESS_TOKEN_PROP)) {
                return;
            }
            this.updateEnabledState((OAuthToken)propertyChangeEvent.getNewValue());
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and cancel authorization", new Object[0]));
        }

        public void cancel() {
            OAuthAuthorizationWizard.this.setCanceled(true);
            OAuthAuthorizationWizard.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }

    class AuthorisationProcedureChangeListener
    implements ItemListener {
        AuthorisationProcedureChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            OAuthAuthorizationWizard.this.refreshAuthorisationProcedurePanel();
        }
    }
}

