/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.merge;

import java.util.Map;
import java.util.function.Consumer;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.inject.Inject;
import javax.inject.Named;
import org.pdfsam.context.UserContext;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.merge.MergeOptionsPane;
import org.pdfsam.merge.MergeParametersBuilder;
import org.pdfsam.merge.MergeSelectionPane;
import org.pdfsam.module.ModuleCategory;
import org.pdfsam.module.ModuleDescriptor;
import org.pdfsam.module.ModuleDescriptorBuilder;
import org.pdfsam.module.ModulePriority;
import org.pdfsam.module.PdfsamModule;
import org.pdfsam.ui.io.BrowsablePdfOutputField;
import org.pdfsam.ui.io.PdfDestinationPane;
import org.pdfsam.ui.module.BaseTaskExecutionModule;
import org.pdfsam.ui.support.Views;
import org.sejda.eventstudio.annotation.EventStation;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@PdfsamModule
public class MergeModule
extends BaseTaskExecutionModule {
    private static final String MODULE_ID = "merge";
    private MergeSelectionPane selectionPane = new MergeSelectionPane("merge");
    private MergeOptionsPane mergeOptions = new MergeOptionsPane();
    private BrowsablePdfOutputField destinationFileField;
    private PdfDestinationPane destinationPane;
    private ModuleDescriptor descriptor = ModuleDescriptorBuilder.builder().category(ModuleCategory.MERGE).name(DefaultI18nContext.getInstance().i18n("Merge")).description(DefaultI18nContext.getInstance().i18n("Merge together multiple PDF documents or subsections of them.")).priority(ModulePriority.HIGH.getPriority()).supportURL("http://www.pdfsam.org/pdf-merge").build();

    @Inject
    public MergeModule(@Named(value="mergefield") BrowsablePdfOutputField destinationFileField, @Named(value="mergepane") PdfDestinationPane destinationPane) {
        this.destinationFileField = destinationFileField;
        this.destinationPane = destinationPane;
    }

    @Override
    public ModuleDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public void onSaveWorkspace(Map<String, String> data) {
        this.selectionPane.saveStateTo(data);
        this.mergeOptions.saveStateTo(data);
        this.destinationFileField.saveStateTo((Map)data);
        this.destinationPane.saveStateTo(data);
    }

    @Override
    public void onLoadWorkspace(Map<String, String> data) {
        this.selectionPane.restoreStateFrom(data);
        this.mergeOptions.restoreStateFrom(data);
        this.destinationFileField.restoreStateFrom((Map)data);
        this.destinationPane.restoreStateFrom(data);
    }

    protected MergeParametersBuilder getBuilder(Consumer<String> onError) {
        MergeParametersBuilder builder = new MergeParametersBuilder();
        this.selectionPane.apply(builder, onError);
        this.mergeOptions.apply(builder, onError);
        this.destinationFileField.apply(builder, onError);
        this.destinationPane.apply(builder, onError);
        return builder;
    }

    @Override
    protected Pane getInnerPanel(Pane footer) {
        VBox pane = new VBox();
        pane.setAlignment(Pos.TOP_CENTER);
        VBox.setVgrow((Node)this.selectionPane, (Priority)Priority.ALWAYS);
        pane.getChildren().addAll((Object[])new Node[]{this.selectionPane, Views.titledPane(DefaultI18nContext.getInstance().i18n("Merge settings"), (Node)this.mergeOptions), Views.titledPane(DefaultI18nContext.getInstance().i18n("Destination file"), (Node)this.destinationPane), footer});
        return pane;
    }

    @Override
    @EventStation
    public String id() {
        return MODULE_ID;
    }

    @Override
    public Node graphic() {
        return new ImageView("merge.png");
    }

    @Configuration
    public static class ModuleConfig {
        @Bean(name={"mergefield"})
        public BrowsablePdfOutputField destinationFileField() {
            return new BrowsablePdfOutputField();
        }

        @Bean(name={"mergepane"})
        public PdfDestinationPane destinationPane(@Named(value="mergefield") BrowsablePdfOutputField outputField, UserContext userContext) {
            return new PdfDestinationPane(outputField, MergeModule.MODULE_ID, userContext, new PdfDestinationPane.DestinationPanelFields[0]);
        }
    }
}

