/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.core.service;

import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.sejda.core.context.DefaultSejdaContext;
import org.sejda.core.context.SejdaContext;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.service.TaskExecutionService;
import org.sejda.core.validation.DefaultValidationContext;
import org.sejda.model.exception.InvalidTaskParametersException;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.base.TaskParameters;
import org.sejda.model.task.Cancellable;
import org.sejda.model.task.CancellationOption;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultTaskExecutionService
implements TaskExecutionService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTaskExecutionService.class);
    private final SejdaContext context = new DefaultSejdaContext();

    @Override
    public void execute(TaskParameters parameters) {
        this.execute(parameters, new CancellationOption());
    }

    @Override
    public void execute(TaskParameters parameters, CancellationOption cancellationOption) {
        StopWatch stopWatch = new StopWatch();
        Task<? extends TaskParameters> task = null;
        LOG.trace("Starting exectution for {}", (Object)parameters);
        try {
            this.validate(parameters);
            task = this.context.getTask(parameters);
            if (task instanceof Cancellable) {
                cancellationOption.setCancellableTask((Cancellable)((Object)task));
            }
            LOG.info("Starting task ({}) execution.", (Object)task);
            this.preExecution(task, stopWatch);
            this.actualExecution(parameters, task);
            this.postExecution(task, stopWatch);
            LOG.info("Task ({}) executed in {}", (Object)task, (Object)DurationFormatUtils.formatDurationWords(stopWatch.getTime(), true, true));
        }
        catch (InvalidTaskParametersException i) {
            LOG.error("Task execution failed due to invalid parameters.", i);
            this.executionFailed(i, task);
        }
        catch (TaskException e) {
            LOG.error(String.format("Task (%s) execution failed.", task), e);
            this.executionFailed(e, task);
        }
        catch (RuntimeException e) {
            this.executionFailed(e, task);
            throw e;
        }
    }

    private void executionFailed(Exception e, Task<?> task) {
        if (task == null) {
            ApplicationEventsNotifier.notifyEvent(NotifiableTaskMetadata.NULL).taskFailed(e);
        } else {
            ApplicationEventsNotifier.notifyEvent(task.getNotifiableTaskMetadata()).taskFailed(e);
        }
    }

    private void validate(TaskParameters parameters) throws InvalidTaskParametersException {
        if (this.context.isValidation()) {
            LOG.debug("Validating parameters.");
            Set<ConstraintViolation<TaskParameters>> violations = DefaultValidationContext.getContext().getValidator().validate(parameters, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder(String.format("Input parameters (%s) are not valid: ", parameters));
                for (ConstraintViolation<TaskParameters> violation : violations) {
                    sb.append(String.format("\"(%s=%s) %s\" ", violation.getPropertyPath(), violation.getInvalidValue(), violation.getMessage()));
                }
                throw new InvalidTaskParametersException(sb.toString());
            }
        } else {
            LOG.info("Validation skipped.");
        }
    }

    private void preExecution(Task<?> task, StopWatch stopWatch) {
        stopWatch.start();
        ApplicationEventsNotifier.notifyEvent(task.getNotifiableTaskMetadata()).taskStarted();
    }

    private void postExecution(Task<?> task, StopWatch stopWatch) {
        stopWatch.stop();
        ApplicationEventsNotifier.notifyEvent(task.getNotifiableTaskMetadata()).taskCompleted(stopWatch.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualExecution(TaskParameters parameters, Task task) throws TaskException {
        try {
            task.before(parameters);
            task.execute(parameters);
        }
        finally {
            try {
                task.after();
            }
            catch (RuntimeException e) {
                LOG.warn("An unexpected error occurred during the execution of the 'after' phase.", e);
            }
        }
    }
}

