/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.text.PDFTextStripperByArea;

public class PdfTextExtractorByArea {
    private static final int GUESSTIMATE_HEADER_FOOTER_HEIGHT = 50;

    public String extractFooterText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getFooterAreaRectangle(page));
    }

    public String extractHeaderText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getHeaderAreaRectangle(page));
    }

    public String extractAddedText(PDPage page, Point2D position) throws TaskIOException {
        return this.extractTextFromArea(page, this.getAddedTextAreaRectangle(page, position));
    }

    private Rectangle getAddedTextAreaRectangle(PDPage page, Point2D position) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageHeight = (int)pageSize.getHeight();
        int pageWidth = (int)pageSize.getWidth();
        int guesstimateTextHeight = 12;
        return new Rectangle((int)position.getX(), pageHeight - (int)position.getY(), pageWidth, guesstimateTextHeight);
    }

    private Rectangle getFooterAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageHeight = (int)pageSize.getHeight();
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, pageHeight - 50, pageWidth, 50);
    }

    private Rectangle getHeaderAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, 0, pageWidth, 50);
    }

    public String extractTextFromArea(PDPage page, Rectangle area) throws TaskIOException {
        try {
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setSortByPosition(true);
            stripper.addRegion("area1", area);
            stripper.extractRegions(page);
            return stripper.getTextForRegion("area1");
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred extracting text from page.", e);
        }
    }
}

