/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.split;

import java.io.File;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.PagesExtractor;
import org.sejda.model.exception.TaskException;
import org.sejda.model.parameter.base.AbstractParameters;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.SinglePdfSourceMultipleOutputParameters;
import org.sejda.model.split.NextOutputStrategy;
import org.sejda.model.task.NotifiableTaskMetadata;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPdfSplitter<T extends SinglePdfSourceMultipleOutputParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPdfSplitter.class);
    private PDDocument document;
    private T parameters;
    private int totalPages;
    private MultipleOutputWriter outputWriter;
    private boolean optimize = false;
    private boolean discardOutline = false;

    public AbstractPdfSplitter(PDDocument document, T parameters, boolean optimize, boolean discardOutline) {
        this.document = document;
        this.parameters = parameters;
        this.totalPages = document.getNumberOfPages();
        this.optimize = optimize;
        this.discardOutline = discardOutline;
        this.outputWriter = OutputWriters.newMultipleOutputWriter(((AbstractParameters)parameters).getExistingOutputPolicy());
    }

    public void split(NotifiableTaskMetadata taskMetadata) throws TaskException {
        this.nextOutputStrategy().ensureIsValid();
        try (PagesExtractor extractor = this.supplyPagesExtractor(this.document);){
            int outputDocumentsCounter = 0;
            File tmpFile = null;
            for (int page = 1; page <= this.totalPages; ++page) {
                taskMetadata.stopTaskIfCancelled();
                if (this.nextOutputStrategy().isOpening(page)) {
                    LOG.debug("Starting split at page {} of the original document", (Object)page);
                    this.onOpen(page);
                    tmpFile = IOUtils.createTemporaryPdfBuffer();
                    LOG.debug("Created output temporary buffer {}", (Object)tmpFile);
                    String outName = NameGenerator.nameGenerator(((SinglePdfSourceMultipleOutputParameters)this.parameters).getOutputPrefix()).generate(this.enrichNameGenerationRequest(NameGenerationRequest.nameRequest().page(page).originalName(((SinglePdfSourceMultipleOutputParameters)this.parameters).getSource().getName()).fileNumber(++outputDocumentsCounter)));
                    this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
                }
                LOG.trace("Retaining page {} of the original document", (Object)page);
                this.onRetain(page);
                extractor.retain(page, taskMetadata);
                ApplicationEventsNotifier.notifyEvent(taskMetadata).stepsCompleted(page).outOf(this.totalPages);
                if (!this.nextOutputStrategy().isClosing(page) && page != this.totalPages) continue;
                this.onClose(page);
                extractor.setVersion(((AbstractPdfOutputParameters)this.parameters).getVersion());
                extractor.setCompress(((AbstractPdfOutputParameters)this.parameters).isCompress());
                if (this.optimize) {
                    extractor.optimize();
                }
                extractor.save(tmpFile, this.discardOutline);
                extractor.reset();
                LOG.debug("Ending split at page {} of the original document, generated document size is {}", (Object)page, (Object)tmpFile.length());
            }
        }
        ((SinglePdfSourceMultipleOutputParameters)this.parameters).getOutput().accept(this.outputWriter);
    }

    abstract NameGenerationRequest enrichNameGenerationRequest(NameGenerationRequest var1);

    abstract NextOutputStrategy nextOutputStrategy();

    protected void onOpen(int page) throws TaskException {
    }

    protected void onRetain(int page) throws TaskException {
    }

    protected void onClose(int page) throws TaskException {
    }

    protected PagesExtractor supplyPagesExtractor(PDDocument document) {
        return new PagesExtractor(document);
    }
}

