/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.task;

import java.io.Serializable;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.sejda.model.exception.TaskCancelledException;
import org.sejda.model.task.BaseTask;

public class NotifiableTaskMetadata
implements Serializable {
    private static final long serialVersionUID = -6423865557633949211L;
    public static final NotifiableTaskMetadata NULL = new NullNotifiableTaskMetadata();
    private UUID taskIdentifier;
    private String qualifiedName;
    private BaseTask<?> task;

    private NotifiableTaskMetadata() {
    }

    public NotifiableTaskMetadata(BaseTask<?> task) {
        if (task == null) {
            throw new IllegalArgumentException("No task given, unable to create notifiable metadata.");
        }
        this.taskIdentifier = UUID.randomUUID();
        this.qualifiedName = task.getClass().getName();
        this.task = task;
    }

    public UUID getTaskIdentifier() {
        return this.taskIdentifier;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.taskIdentifier).append(this.qualifiedName).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotifiableTaskMetadata)) {
            return false;
        }
        NotifiableTaskMetadata meta = (NotifiableTaskMetadata)other;
        return new EqualsBuilder().append(this.taskIdentifier, meta.taskIdentifier).append(this.qualifiedName, meta.qualifiedName).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.SHORT_PREFIX_STYLE).append("taskIdentifier", this.taskIdentifier).append("qualifiedName", this.qualifiedName).toString();
    }

    public void stopTaskIfCancelled() throws TaskCancelledException {
        this.task.stopTaskIfCancelled();
    }

    private static class NullNotifiableTaskMetadata
    extends NotifiableTaskMetadata {
        private static final long serialVersionUID = 6788562820506828221L;

        private NullNotifiableTaskMetadata() {
        }

        @Override
        public UUID getTaskIdentifier() {
            return null;
        }

        @Override
        public String getQualifiedName() {
            return "";
        }
    }
}

