/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.DeveloperException;
import ch.softenvironment.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DOMUtils {
    public static String encodeUTF8(String origin) throws UnsupportedEncodingException {
        return new String(origin.getBytes("UTF-8"));
    }

    public static DocumentBuilder createDocumentBuilder(boolean validating) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Tracer.getInstance().debug("DocumentBuilderFactory=" + factory);
        factory.setValidating(validating);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new DefaultErrorHandler());
        Tracer.getInstance().debug("DocumentBuilder=" + builder);
        return builder;
    }

    public static void transform(String xml, String xsl, Writer writer) throws TransformerConfigurationException, TransformerException, DeveloperException {
        File xmlFile = new File(xml);
        File xsltFile = new File(xsl);
        if (!xmlFile.canRead() || !xsltFile.canRead()) {
            throw new DeveloperException("one or both filenames not readable");
        }
        TransformerFactory transFactory = TransformerFactory.newInstance();
        StreamSource xmlSrc = new StreamSource(xmlFile);
        StreamSource xsltSrc = new StreamSource(xsltFile);
        Transformer transformer = transFactory.newTransformer(xsltSrc);
        StreamResult result = new StreamResult(writer);
        transformer.transform(xmlSrc, result);
    }

    public static Document read(String filename, DocumentBuilder builder) throws ParserConfigurationException, SAXParseException, IOException, SAXException {
        File file = new File(filename);
        if (file.canRead()) {
            try {
                DocumentBuilder tmp = builder;
                if (tmp == null) {
                    tmp = DOMUtils.createDocumentBuilder(false);
                }
                Document document = tmp.parse(file);
                return document;
            }
            catch (SAXParseException pe) {
                Tracer.getInstance().runtimeError(filename + " Parse-Error (row=" + pe.getLineNumber() + ")", pe);
                throw pe;
            }
            catch (IOException ioe) {
                Tracer.getInstance().runtimeError(filename + " IOException", ioe);
                throw ioe;
            }
            catch (SAXException saxe) {
                Tracer.getInstance().runtimeError(filename + " SAXException", saxe);
                throw saxe;
            }
        }
        Tracer.getInstance().runtimeWarning(filename + " not existing or readable!");
        return null;
    }

    public static void writeXML(Document document, Writer writer) throws TransformerConfigurationException, TransformerException {
        Transformer trn = TransformerFactory.newInstance().newTransformer();
        trn.setOutputProperty("method", "xml");
        trn.setOutputProperty("encoding", "UTF-8");
        StreamResult result = new StreamResult(writer);
        trn.transform(new DOMSource(document), result);
    }

    private static class DefaultErrorHandler
    implements ErrorHandler {
        private DefaultErrorHandler() {
        }

        private String getDetailedMessage(SAXParseException error) {
            return "Row=" + error.getLineNumber() + "\n SystemId=" + error.getSystemId() + (error.getPublicId() == null ? "" : "\n PublicId=" + error.getPublicId()) + "\n errorMessage=" + error.getMessage() + (error.getCause() == null ? "" : "\n cause=" + error.getCause());
        }

        @Override
        public void warning(SAXParseException error) {
            Tracer.getInstance().runtimeWarning(this.getDetailedMessage(error));
        }

        @Override
        public void error(SAXParseException error) {
            Tracer.getInstance().runtimeError(this.getDetailedMessage(error), error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            Tracer.getInstance().developerError(this.getDetailedMessage(error));
        }
    }
}

