/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.view;

import ch.ehi.basics.view.BrowserControl;
import ch.softenvironment.client.ResourceManager;
import ch.softenvironment.view.BaseDialog;
import ch.softenvironment.view.BaseFrame;
import ch.softenvironment.view.URLViewListener;
import ch.softenvironment.view.URLViewListenerEventMulticaster;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class URLView
extends JPanel {
    private JButton ivjBtnBrowser = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();
    private JTextField ivjTxtURL = null;
    protected transient URLViewListener fieldURLViewListenerEventMulticaster = null;

    public URLView() {
        this.initialize();
    }

    public URLView(LayoutManager layout) {
        super(layout);
    }

    public URLView(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public URLView(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public void addURLViewListener(URLViewListener newListener) {
        this.fieldURLViewListenerEventMulticaster = URLViewListenerEventMulticaster.add(this.fieldURLViewListenerEventMulticaster, newListener);
    }

    private void browse() {
        try {
            BrowserControl.displayURL(this.getTxtURLText());
        }
        catch (Throwable e) {
            BaseDialog.showWarning(this, ResourceManager.getResource(URLView.class, "CT_BrowserError"), e.toString());
        }
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.browse();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(KeyEvent arg1) {
        try {
            this.fireUrlKeyReleased(new EventObject(this));
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    protected void fireUrlKeyReleased(EventObject newEvent) {
        if (this.fieldURLViewListenerEventMulticaster == null) {
            return;
        }
        this.fieldURLViewListenerEventMulticaster.urlKeyReleased(newEvent);
    }

    private JButton getBtnBrowser() {
        if (this.ivjBtnBrowser == null) {
            try {
                this.ivjBtnBrowser = new JButton();
                this.ivjBtnBrowser.setName("BtnBrowser");
                this.ivjBtnBrowser.setToolTipText("in Browser \u00f6ffnen...");
                this.ivjBtnBrowser.setText("...");
                this.ivjBtnBrowser.setEnabled(true);
                this.ivjBtnBrowser.setToolTipText(ResourceManager.getResource(URLView.class, "CW_OpenInBrowser"));
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjBtnBrowser;
    }

    public String getText() {
        return this.getTxtURL().getText();
    }

    private JTextField getTxtURL() {
        if (this.ivjTxtURL == null) {
            try {
                this.ivjTxtURL = new JTextField();
                this.ivjTxtURL.setName("TxtURL");
                this.ivjTxtURL.setToolTipText("URL");
                this.ivjTxtURL.setAlignmentX(0.0f);
                this.ivjTxtURL.setAlignmentY(0.0f);
                this.ivjTxtURL.setText("http://");
                this.ivjTxtURL.setToolTipText("URL (http://..; file://..; ..");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjTxtURL;
    }

    public String getTxtURLText() {
        return this.getTxtURL().getText();
    }

    private void handleException(Throwable exception) {
        BaseFrame.showException(null, exception);
    }

    private void initConnections() throws Exception {
        this.getBtnBrowser().addActionListener(this.ivjEventHandler);
        this.getTxtURL().addKeyListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("URLView");
            this.setLayout(new GridBagLayout());
            this.setSize(242, 28);
            GridBagConstraints constraintsTxtURL = new GridBagConstraints();
            constraintsTxtURL.gridx = 1;
            constraintsTxtURL.gridy = 1;
            constraintsTxtURL.fill = 2;
            constraintsTxtURL.anchor = 18;
            constraintsTxtURL.weightx = 1.0;
            constraintsTxtURL.ipadx = 196;
            constraintsTxtURL.insets = new Insets(3, 0, 5, 2);
            this.add((Component)this.getTxtURL(), constraintsTxtURL);
            GridBagConstraints constraintsBtnBrowser = new GridBagConstraints();
            constraintsBtnBrowser.gridx = 2;
            constraintsBtnBrowser.gridy = 1;
            constraintsBtnBrowser.anchor = 18;
            constraintsBtnBrowser.ipadx = -7;
            constraintsBtnBrowser.insets = new Insets(1, 3, 2, 1);
            this.add((Component)this.getBtnBrowser(), constraintsBtnBrowser);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    public void removeURLViewListener(URLViewListener newListener) {
        this.fieldURLViewListenerEventMulticaster = URLViewListenerEventMulticaster.remove(this.fieldURLViewListenerEventMulticaster, newListener);
    }

    public void setText(String arg1) {
        this.getTxtURL().setText(arg1);
    }

    public void setTxtURLText(String arg1) {
        this.getTxtURL().setText(arg1);
    }

    class IvjEventHandler
    implements ActionListener,
    KeyListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == URLView.this.getBtnBrowser()) {
                URLView.this.connEtoC1(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() == URLView.this.getTxtURL()) {
                URLView.this.connEtoC2(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

