/*
 * Decompiled with CFR 0.152.
 */
package org.sourceforge.jlibeps.epsgraphics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.sourceforge.jlibeps.epsgraphics.EpsException;
import org.sourceforge.jlibeps.epsgraphics.EpsGraphics2D;

public class EpsDocument {
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private boolean _isClipSet = false;
    private String _title;
    private StringWriter _stringWriter;
    private BufferedWriter _bufferedWriter = null;
    private EpsGraphics2D _lastG = null;

    public EpsDocument(String title) {
        this._title = title;
        this.minX = Float.POSITIVE_INFINITY;
        this.minY = Float.POSITIVE_INFINITY;
        this.maxX = Float.NEGATIVE_INFINITY;
        this.maxY = Float.NEGATIVE_INFINITY;
        this._stringWriter = new StringWriter();
        this._bufferedWriter = new BufferedWriter(this._stringWriter);
    }

    public EpsDocument(String title, OutputStream outputStream, int minX, int minY, int maxX, int maxY) throws IOException {
        this._title = title;
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this._bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.write(this._bufferedWriter);
    }

    public synchronized String getTitle() {
        return this._title;
    }

    public synchronized void updateBounds(double x, double y) {
        if (x > (double)this.maxX) {
            this.maxX = (float)x;
        }
        if (x < (double)this.minX) {
            this.minX = (float)x;
        }
        if (y > (double)this.maxY) {
            this.maxY = (float)y;
        }
        if (y < (double)this.minY) {
            this.minY = (float)y;
        }
    }

    public synchronized void append(EpsGraphics2D g, String line) {
        if (this._lastG == null) {
            this._lastG = g;
        } else if (g != this._lastG) {
            EpsGraphics2D lastG = this._lastG;
            this._lastG = g;
            if (g.getClip() != lastG.getClip()) {
                g.setClip(g.getClip());
            }
            if (!g.getColor().equals(lastG.getColor())) {
                g.setColor(g.getColor());
            }
            if (!g.getBackground().equals(lastG.getBackground())) {
                g.setBackground(g.getBackground());
            }
            if (!g.getPaint().equals(lastG.getPaint())) {
                g.setPaint(g.getPaint());
            }
            if (!g.getComposite().equals(lastG.getComposite())) {
                g.setComposite(g.getComposite());
            }
            if (!g.getComposite().equals(lastG.getComposite())) {
                g.setComposite(g.getComposite());
            }
            if (!g.getFont().equals(lastG.getFont())) {
                g.setFont(g.getFont());
            }
            if (!g.getStroke().equals(lastG.getStroke())) {
                g.setStroke(g.getStroke());
            }
        }
        this._lastG = g;
        try {
            this._bufferedWriter.write(String.valueOf(line) + "\n");
        }
        catch (IOException e) {
            throw new EpsException("Could not write to the output file: " + e);
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        float offsetX = -this.minX;
        float offsetY = -this.minY;
        writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        writer.write("%%Creator: jlibeps 0.1, https://sourceforge.net/projects/jlibeps/\n");
        writer.write("%%Title: " + this._title + "\n");
        writer.write("%%CreationDate: " + new Date() + "\n");
        writer.write("%%BoundingBox: 0 0 " + (int)Math.ceil(this.maxX + offsetX) + " " + (int)Math.ceil(this.maxY + offsetY) + "\n");
        writer.write("%%DocumentData: Clean7Bit\n");
        writer.write("%%DocumentProcessColors: Black\n");
        writer.write("%%ColorUsage: Color\n");
        writer.write("%%Origin: 0 0\n");
        writer.write("%%Pages: 1\n");
        writer.write("%%Page: 1 1\n");
        writer.write("%%EndComments\n\n");
        writer.write("gsave\n");
        if (this._stringWriter != null) {
            writer.write(String.valueOf(offsetX) + " " + offsetY + " translate\n");
            this._bufferedWriter.flush();
            StringBuffer buffer = this._stringWriter.getBuffer();
            int i = 0;
            while (i < buffer.length()) {
                writer.write(buffer.charAt(i));
                ++i;
            }
            this.writeFooter(writer);
        } else {
            writer.write(String.valueOf(offsetX) + " " + (this.maxY - this.minY - offsetY) + " translate\n");
        }
        writer.flush();
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("grestore\n");
        if (this.isClipSet()) {
            writer.write("grestore\n");
        }
        writer.write("showpage\n");
        writer.write("\n");
        writer.write("%%EOF");
        writer.flush();
    }

    public synchronized void flush() throws IOException {
        this._bufferedWriter.flush();
    }

    public synchronized void close() throws IOException {
        if (this._stringWriter == null) {
            this.writeFooter(this._bufferedWriter);
            this._bufferedWriter.flush();
            this._bufferedWriter.close();
        }
    }

    public boolean isClipSet() {
        return this._isClipSet;
    }

    public void setClipSet(boolean isClipSet) {
        this._isClipSet = isClipSet;
    }
}

