/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValue;
import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import javafx.scene.text.Font;

public class Margins {
    private final double top;
    private final double right;
    private final double bottom;
    private final double left;
    private final boolean proportional;

    public final double getTop() {
        return this.top;
    }

    public final double getRight() {
        return this.right;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getLeft() {
        return this.left;
    }

    public final boolean isProportional() {
        return this.proportional;
    }

    public Margins(double d, double d2, double d3, double d4, boolean bl) {
        this.top = d;
        this.right = d2;
        this.bottom = d3;
        this.left = d4;
        this.proportional = bl;
    }

    public String toString() {
        return "top: " + this.top + "\nright: " + this.right + "\nbottom: " + this.bottom + "\nleft: " + this.left;
    }

    public static final class Converter
    extends StyleConverter<ParsedValue<?, Size>[], Margins> {
        public static Converter getInstance() {
            return Holder.CONVERTER_INSTANCE;
        }

        private Converter() {
        }

        @Override
        public Margins convert(ParsedValue<ParsedValue<?, Size>[], Margins> parsedValue, Font font) {
            ParsedValue<?, Size>[] parsedValueArray = parsedValue.getValue();
            Size size = parsedValueArray.length > 0 ? parsedValueArray[0].convert(font) : new Size(0.0, SizeUnits.PX);
            Size size2 = parsedValueArray.length > 1 ? parsedValueArray[1].convert(font) : size;
            Size size3 = parsedValueArray.length > 2 ? parsedValueArray[2].convert(font) : size;
            Size size4 = parsedValueArray.length > 3 ? parsedValueArray[3].convert(font) : size2;
            boolean bl = false;
            if (size.getUnits() == size2.getUnits() && size.getUnits() == size3.getUnits() && size.getUnits() == size4.getUnits()) {
                bl = size.getUnits() == SizeUnits.PERCENT;
            } else {
                System.err.println("units do not match");
            }
            double d = size.pixels(font);
            double d2 = size2.pixels(font);
            double d3 = size3.pixels(font);
            double d4 = size4.pixels(font);
            return new Margins(d, d2, d3, d4, bl);
        }

        public String toString() {
            return "MarginsConverter";
        }
    }

    private static class Holder {
        static Converter CONVERTER_INSTANCE = new Converter();
        static SequenceConverter SEQUENCE_CONVERTER_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<ParsedValue<ParsedValue<?, Size>[], Margins>[], Margins[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_CONVERTER_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Margins[] convert(ParsedValue<ParsedValue<ParsedValue<?, Size>[], Margins>[], Margins[]> parsedValue, Font font) {
            ParsedValue<ParsedValue<?, Size>[], Margins>[] parsedValueArray = parsedValue.getValue();
            Margins[] marginsArray = new Margins[parsedValueArray.length];
            for (int i = 0; i < parsedValueArray.length; ++i) {
                marginsArray[i] = Converter.getInstance().convert((ParsedValue)parsedValueArray[i], font);
            }
            return marginsArray;
        }

        public String toString() {
            return "MarginsSequenceConverter";
        }
    }
}

