/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.binding;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.bind.util.Which;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.FeatureConstructor;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.resources.ModelerMessages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.ws.RespectBinding;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.Addressing;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.soap.MTOM;
import javax.xml.ws.soap.MTOMFeature;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;

public final class WebServiceFeatureList
implements WSFeatureList {
    private Map<Class<? extends WebServiceFeature>, WebServiceFeature> wsfeatures = new HashMap<Class<? extends WebServiceFeature>, WebServiceFeature>();
    @Nullable
    private WSDLFeaturedObject parent;
    private static final Logger LOGGER = Logger.getLogger(WebServiceFeatureList.class.getName());

    public WebServiceFeatureList() {
    }

    public WebServiceFeatureList(WebServiceFeature ... features) {
        if (features != null) {
            for (WebServiceFeature f : features) {
                this.wsfeatures.put(f.getClass(), f);
            }
        }
    }

    public WebServiceFeatureList(@NotNull Class<?> endpointClass) {
        this.parseAnnotations(endpointClass);
    }

    public void parseAnnotations(Iterable<Annotation> annIt) {
        for (Annotation ann : annIt) {
            WebServiceFeature feature = WebServiceFeatureList.getFeature(ann);
            if (feature == null) continue;
            this.add(feature);
        }
    }

    public static WebServiceFeature getFeature(Annotation a) {
        WebServiceFeature ftr;
        if (!a.annotationType().isAnnotationPresent(WebServiceFeatureAnnotation.class)) {
            ftr = null;
        } else if (a instanceof Addressing) {
            Addressing addAnn = (Addressing)a;
            try {
                ftr = new AddressingFeature(addAnn.enabled(), addAnn.required(), addAnn.responses());
            }
            catch (NoSuchMethodError e) {
                throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_ADDRESSING_RESPONSES_NOSUCHMETHOD(WebServiceFeatureList.toJar(Which.which(Addressing.class))), new Object[0]);
            }
        } else if (a instanceof MTOM) {
            MTOM mtomAnn = (MTOM)a;
            ftr = new MTOMFeature(mtomAnn.enabled(), mtomAnn.threshold());
        } else if (a instanceof RespectBinding) {
            RespectBinding rbAnn = (RespectBinding)a;
            ftr = new RespectBindingFeature(rbAnn.enabled());
        } else {
            ftr = WebServiceFeatureList.getWebServiceFeatureBean(a);
        }
        return ftr;
    }

    public void parseAnnotations(Class<?> endpointClass) {
        for (Annotation a : endpointClass.getAnnotations()) {
            BindingID bindingID;
            MTOMFeature bindingMtomSetting;
            WebServiceFeature ftr = WebServiceFeatureList.getFeature(a);
            if (ftr == null) continue;
            if (ftr instanceof MTOMFeature && (bindingMtomSetting = (bindingID = BindingID.parse(endpointClass)).createBuiltinFeatureList().get(MTOMFeature.class)) != null && bindingMtomSetting.isEnabled() ^ ftr.isEnabled()) {
                throw new RuntimeModelerException(ModelerMessages.RUNTIME_MODELER_MTOM_CONFLICT(bindingID, ftr.isEnabled()), new Object[0]);
            }
            this.add(ftr);
        }
    }

    private static String toJar(String url) {
        if (!url.startsWith("jar:")) {
            return url;
        }
        url = url.substring(4);
        return url.substring(0, url.lastIndexOf(33));
    }

    private static WebServiceFeature getWebServiceFeatureBean(Annotation a) {
        WebServiceFeature bean;
        WebServiceFeatureAnnotation wsfa = a.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
        Class<? extends WebServiceFeature> beanClass = wsfa.bean();
        Constructor<?> ftrCtr = null;
        String[] paramNames = null;
        for (Constructor<?> con : beanClass.getConstructors()) {
            FeatureConstructor ftrCtrAnn = con.getAnnotation(FeatureConstructor.class);
            if (ftrCtrAnn == null) continue;
            if (ftrCtr == null) {
                ftrCtr = con;
                paramNames = ftrCtrAnn.value();
                continue;
            }
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_MORETHANONE_FTRCONSTRUCTOR(a, beanClass));
        }
        if (ftrCtr == null) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_NO_FTRCONSTRUCTOR(a, beanClass));
        }
        if (ftrCtr.getParameterTypes().length != paramNames.length) {
            throw new WebServiceException(ModelerMessages.RUNTIME_MODELER_WSFEATURE_ILLEGAL_FTRCONSTRUCTOR(a, beanClass));
        }
        try {
            Object[] params = new Object[paramNames.length];
            for (int i = 0; i < paramNames.length; ++i) {
                Method m = a.annotationType().getDeclaredMethod(paramNames[i], new Class[0]);
                params[i] = m.invoke(a, new Object[0]);
            }
            bean = (WebServiceFeature)ftrCtr.newInstance(params);
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
        return bean;
    }

    @Override
    public Iterator<WebServiceFeature> iterator() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures());
        }
        return this.wsfeatures.values().iterator();
    }

    @Override
    @NotNull
    public WebServiceFeature[] toArray() {
        if (this.parent != null) {
            return new MergedFeatures(this.parent.getFeatures()).toArray();
        }
        return this.wsfeatures.values().toArray(new WebServiceFeature[0]);
    }

    @Override
    public boolean isEnabled(@NotNull Class<? extends WebServiceFeature> feature) {
        WebServiceFeature ftr = this.get(feature);
        return ftr != null && ftr.isEnabled();
    }

    @Override
    @Nullable
    public <F extends WebServiceFeature> F get(@NotNull Class<F> featureType) {
        WebServiceFeature f = (WebServiceFeature)featureType.cast(this.wsfeatures.get(featureType));
        if (f == null && this.parent != null) {
            return this.parent.getFeatures().get(featureType);
        }
        return (F)f;
    }

    public void add(@NotNull WebServiceFeature f) {
        if (!this.wsfeatures.containsKey(f.getClass())) {
            this.wsfeatures.put(f.getClass(), f);
        }
    }

    public void addAll(@NotNull WSFeatureList list) {
        for (WebServiceFeature f : list) {
            this.add(f);
        }
    }

    @Override
    public void mergeFeatures(@NotNull Iterable<WebServiceFeature> features, boolean reportConflicts) {
        for (WebServiceFeature wsdlFtr : features) {
            if (this.get(wsdlFtr.getClass()) == null) {
                this.add(wsdlFtr);
                continue;
            }
            if (!reportConflicts || this.isEnabled(wsdlFtr.getClass()) == wsdlFtr.isEnabled()) continue;
            LOGGER.warning(ModelerMessages.RUNTIME_MODELER_FEATURE_CONFLICT(this.get(wsdlFtr.getClass()), wsdlFtr));
        }
    }

    @Override
    public void mergeFeatures(WebServiceFeature[] features, boolean reportConflicts) {
        for (WebServiceFeature wsdlFtr : features) {
            if (this.get(wsdlFtr.getClass()) == null) {
                this.add(wsdlFtr);
                continue;
            }
            if (!reportConflicts || this.isEnabled(wsdlFtr.getClass()) == wsdlFtr.isEnabled()) continue;
            LOGGER.warning(ModelerMessages.RUNTIME_MODELER_FEATURE_CONFLICT(this.get(wsdlFtr.getClass()), wsdlFtr));
        }
    }

    public void setParentFeaturedObject(@NotNull WSDLFeaturedObject parent) {
        this.parent = parent;
    }

    @Nullable
    public static <F extends WebServiceFeature> F getFeature(@NotNull WebServiceFeature[] features, @NotNull Class<F> featureType) {
        for (WebServiceFeature f : features) {
            if (f.getClass() != featureType) continue;
            return (F)f;
        }
        return null;
    }

    private final class MergedFeatures
    implements Iterator<WebServiceFeature> {
        private final Stack<WebServiceFeature> features = new Stack();

        public MergedFeatures(WSFeatureList parent) {
            for (WebServiceFeature f : WebServiceFeatureList.this.wsfeatures.values()) {
                this.features.push(f);
            }
            for (WebServiceFeature f : parent) {
                if (WebServiceFeatureList.this.wsfeatures.containsKey(f.getClass())) continue;
                this.features.push(f);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.features.empty();
        }

        @Override
        public WebServiceFeature next() {
            if (!this.features.empty()) {
                return this.features.pop();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.features.empty()) {
                this.features.pop();
            }
        }

        public WebServiceFeature[] toArray() {
            return this.features.toArray(new WebServiceFeature[0]);
        }
    }
}

