/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandomSpi;
import sun.security.provider.SeedGenerator;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable {
    private static final long serialVersionUID = 3581829991155417889L;
    private static final int DIGEST_SIZE = 20;
    private transient MessageDigest digest;
    private byte[] state;
    private byte[] remainder;
    private int remCount;

    public SecureRandom() {
        this.init(null);
    }

    private SecureRandom(byte[] seed) {
        this.init(seed);
    }

    private void init(byte[] seed) {
        try {
            this.digest = MessageDigest.getInstance("SHA", "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            try {
                this.digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException exc) {
                throw new InternalError("internal error: SHA-1 not available.");
            }
        }
        if (seed != null) {
            this.engineSetSeed(seed);
        }
    }

    @Override
    public byte[] engineGenerateSeed(int numBytes) {
        byte[] b = new byte[numBytes];
        SeedGenerator.generateSeed(b);
        return b;
    }

    @Override
    public synchronized void engineSetSeed(byte[] seed) {
        if (this.state != null) {
            this.digest.update(this.state);
            for (int i = 0; i < this.state.length; ++i) {
                this.state[i] = 0;
            }
        }
        this.state = this.digest.digest(seed);
    }

    private static void updateState(byte[] state, byte[] output) {
        int last = 1;
        int v = 0;
        byte t = 0;
        boolean zf = false;
        for (int i = 0; i < state.length; ++i) {
            v = state[i] + output[i] + last;
            t = (byte)v;
            zf |= state[i] != t;
            state[i] = t;
            last = v >> 8;
        }
        if (!zf) {
            state[0] = (byte)(state[0] + 1);
        }
    }

    @Override
    public synchronized void engineNextBytes(byte[] result) {
        int i;
        int todo;
        int r;
        int index = 0;
        byte[] output = this.remainder;
        if (this.state == null) {
            byte[] seed = new byte[20];
            SeederHolder.seeder.engineNextBytes(seed);
            this.state = this.digest.digest(seed);
        }
        if ((r = this.remCount) > 0) {
            todo = result.length - index < 20 - r ? result.length - index : 20 - r;
            for (i = 0; i < todo; ++i) {
                result[i] = output[r];
                output[r++] = 0;
            }
            this.remCount += todo;
            index += todo;
        }
        while (index < result.length) {
            this.digest.update(this.state);
            output = this.digest.digest();
            SecureRandom.updateState(this.state, output);
            todo = result.length - index > 20 ? 20 : result.length - index;
            for (i = 0; i < todo; ++i) {
                result[index++] = output[i];
                output[i] = 0;
            }
            this.remCount += todo;
        }
        this.remainder = output;
        this.remCount %= 20;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.digest = MessageDigest.getInstance("SHA", "SUN");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            try {
                this.digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException exc) {
                throw new InternalError("internal error: SHA-1 not available.");
            }
        }
    }

    private static class SeederHolder {
        private static final SecureRandom seeder = new SecureRandom(SeedGenerator.getSystemEntropy());

        private SeederHolder() {
        }

        static {
            byte[] b = new byte[20];
            SeedGenerator.generateSeed(b);
            seeder.engineSetSeed(b);
        }
    }
}

