/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.PseudoCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.util.NameVisitor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangePropertyKeyCommand
extends Command {
    private final List<? extends OsmPrimitive> objects;
    private final String key;
    private final String newKey;

    public ChangePropertyKeyCommand(OsmPrimitive osmPrimitive, String string, String string2) {
        this(Collections.singleton(osmPrimitive), string, string2);
    }

    public ChangePropertyKeyCommand(Collection<? extends OsmPrimitive> collection, String string, String string2) {
        this.objects = new LinkedList<OsmPrimitive>(collection);
        this.key = string;
        this.newKey = string2;
    }

    @Override
    public boolean executeCommand() {
        if (!super.executeCommand()) {
            return false;
        }
        for (OsmPrimitive osmPrimitive : this.objects) {
            if (!osmPrimitive.hasKeys()) continue;
            osmPrimitive.setModified(true);
            String string = osmPrimitive.get(this.key);
            osmPrimitive.put(this.newKey, string);
            osmPrimitive.remove(this.key);
        }
        return true;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> collection, Collection<OsmPrimitive> collection2, Collection<OsmPrimitive> collection3) {
        collection.addAll(this.objects);
    }

    @Override
    public String getDescriptionText() {
        String string = I18n.tr("Replace \"{0}\" by \"{1}\" for", this.key, this.newKey);
        if (this.objects.size() == 1) {
            NameVisitor nameVisitor = new NameVisitor();
            this.objects.get(0).accept(nameVisitor);
            string = string + ' ' + I18n.tr(nameVisitor.className, new Object[0]) + ' ' + nameVisitor.name;
        } else {
            string = string + (32 + this.objects.size() + 32) + I18n.trn("object", "objects", this.objects.size(), new Object[0]);
        }
        return string;
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "key");
    }

    @Override
    public Collection<PseudoCommand> getChildren() {
        if (this.objects.size() == 1) {
            return null;
        }
        ArrayList<PseudoCommand> arrayList = new ArrayList<PseudoCommand>();
        final NameVisitor nameVisitor = new NameVisitor();
        for (final OsmPrimitive osmPrimitive : this.objects) {
            osmPrimitive.accept(nameVisitor);
            arrayList.add(new PseudoCommand(){

                @Override
                public String getDescriptionText() {
                    return nameVisitor.name;
                }

                @Override
                public Icon getDescriptionIcon() {
                    return nameVisitor.icon;
                }

                @Override
                public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
                    return Collections.singleton(osmPrimitive);
                }
            });
        }
        return arrayList;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.objects, this.key, this.newKey);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ChangePropertyKeyCommand changePropertyKeyCommand = (ChangePropertyKeyCommand)object;
        return Objects.equals(this.objects, changePropertyKeyCommand.objects) && Objects.equals(this.key, changePropertyKeyCommand.key) && Objects.equals(this.newKey, changePropertyKeyCommand.newKey);
    }
}

