/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.preferences.CollectionProperty;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.server.ApiUrlTestTask;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class OsmApiUrlInputPanel
extends JPanel {
    public static final String API_URL_PROP = OsmApiUrlInputPanel.class.getName() + ".apiUrl";
    private final JLabel lblValid = new JLabel();
    private final JLabel lblApiUrl = new JLabel(I18n.tr("OSM Server URL:", new Object[0]));
    private final HistoryComboBox tfOsmServerUrl = new HistoryComboBox();
    private transient ApiUrlValidator valOsmServerUrl;
    private SideButton btnTest;
    private JCheckBox cbUseDefaultServerUrl;
    private final transient CollectionProperty SERVER_URL_HISTORY = new CollectionProperty("osm-server.url-history", (Collection<String>)Arrays.asList("http://api06.dev.openstreetmap.org/api", "http://master.apis.dev.openstreetmap.org/api"));
    private transient ApiUrlPropagator propagator;

    public OsmApiUrlInputPanel() {
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Preferences/Connection#ApiUrl"));
    }

    protected JComponent buildDefaultServerUrlPanel() {
        this.cbUseDefaultServerUrl = new JCheckBox(I18n.tr("<html>Use the default OSM server URL (<strong>{0}</strong>)</html>", "https://api.openstreetmap.org/api"));
        this.cbUseDefaultServerUrl.addItemListener(new UseDefaultServerUrlChangeHandler());
        this.cbUseDefaultServerUrl.setFont(this.cbUseDefaultServerUrl.getFont().deriveFont(0));
        return this.cbUseDefaultServerUrl;
    }

    protected final void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridwidth = 4;
        this.add((Component)this.buildDefaultServerUrlPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.lblApiUrl, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfOsmServerUrl, gridBagConstraints);
        this.lblApiUrl.setLabelFor(this.tfOsmServerUrl);
        SelectAllOnFocusGainedDecorator.decorate(this.tfOsmServerUrl.getEditorComponent());
        this.valOsmServerUrl = new ApiUrlValidator(this.tfOsmServerUrl.getEditorComponent());
        this.valOsmServerUrl.validate();
        this.propagator = new ApiUrlPropagator();
        this.tfOsmServerUrl.addActionListener(this.propagator);
        this.tfOsmServerUrl.addFocusListener(this.propagator);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.lblValid, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        ValidateApiUrlAction validateApiUrlAction = new ValidateApiUrlAction();
        this.tfOsmServerUrl.getEditorComponent().getDocument().addDocumentListener(validateApiUrlAction);
        this.btnTest = new SideButton(validateApiUrlAction);
        this.add((Component)this.btnTest, gridBagConstraints);
    }

    public void initFromPreferences() {
        String string = OsmApi.getOsmApi().getServerUrl();
        this.tfOsmServerUrl.setPossibleItems((Collection<String>)this.SERVER_URL_HISTORY.get());
        if ("https://api.openstreetmap.org/api".equals(string.trim())) {
            this.cbUseDefaultServerUrl.setSelected(true);
            this.propagator.propagate("https://api.openstreetmap.org/api");
        } else {
            this.cbUseDefaultServerUrl.setSelected(false);
            this.tfOsmServerUrl.setText(string);
            this.propagator.propagate(string);
        }
    }

    public void saveToPreferences() {
        String string = OsmApi.getOsmApi().getServerUrl();
        String string2 = this.getStrippedApiUrl();
        if (this.cbUseDefaultServerUrl.isSelected() || "https://api.openstreetmap.org/api".equals(string2)) {
            Main.pref.put("osm-server.url", null);
        } else {
            Main.pref.put("osm-server.url", string2);
            this.tfOsmServerUrl.addCurrentItemToHistory();
            this.SERVER_URL_HISTORY.put((Collection<String>)this.tfOsmServerUrl.getHistory());
        }
        String string3 = OsmApi.getOsmApi().getServerUrl();
        if (!string.equals(string3)) {
            try {
                OsmApi.getOsmApi().initialize(null);
            }
            catch (OsmApiInitializationException | OsmTransferCanceledException osmTransferException) {
                Main.warn(osmTransferException);
            }
        }
    }

    public final String getStrippedApiUrl() {
        return Utils.strip(this.tfOsmServerUrl.getText());
    }

    public void setApiUrlInputEnabled(boolean bl) {
        this.lblApiUrl.setEnabled(bl);
        this.tfOsmServerUrl.setEnabled(bl);
        this.lblValid.setEnabled(bl);
        this.btnTest.setEnabled(bl);
    }

    class ApiUrlPropagator
    extends FocusAdapter
    implements ActionListener {
        ApiUrlPropagator() {
        }

        protected void propagate() {
            this.propagate(OsmApiUrlInputPanel.this.getStrippedApiUrl());
        }

        protected void propagate(String string) {
            OsmApiUrlInputPanel.this.firePropertyChange(API_URL_PROP, null, string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.propagate();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.propagate();
        }
    }

    class UseDefaultServerUrlChangeHandler
    implements ItemListener {
        UseDefaultServerUrlChangeHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            switch (itemEvent.getStateChange()) {
                case 1: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(false);
                    OsmApiUrlInputPanel.this.propagator.propagate("https://api.openstreetmap.org/api");
                    break;
                }
                case 2: {
                    OsmApiUrlInputPanel.this.setApiUrlInputEnabled(true);
                    OsmApiUrlInputPanel.this.valOsmServerUrl.validate();
                    OsmApiUrlInputPanel.this.tfOsmServerUrl.requestFocusInWindow();
                    OsmApiUrlInputPanel.this.propagator.propagate();
                    break;
                }
            }
        }
    }

    private static class ApiUrlValidator
    extends AbstractTextComponentValidator {
        ApiUrlValidator(JTextComponent jTextComponent) {
            super(jTextComponent);
        }

        @Override
        public boolean isValid() {
            if (this.getComponent().getText().trim().isEmpty()) {
                return false;
            }
            return Utils.isValidUrl(this.getComponent().getText().trim());
        }

        @Override
        public void validate() {
            if (this.getComponent().getText().trim().isEmpty()) {
                this.feedbackInvalid(I18n.tr("OSM API URL must not be empty. Please enter the OSM API URL.", new Object[0]));
                return;
            }
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid URL", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter the OSM API URL.", new Object[0]));
            }
        }
    }

    class ValidateApiUrlAction
    extends AbstractAction
    implements DocumentListener {
        private String lastTestedUrl;

        ValidateApiUrlAction() {
            this.putValue("Name", I18n.tr("Validate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Test the API URL", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            final String string = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            final ApiUrlTestTask apiUrlTestTask = new ApiUrlTestTask(OsmApiUrlInputPanel.this, string);
            Main.worker.submit(apiUrlTestTask);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (apiUrlTestTask.isCanceled()) {
                        return;
                    }
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (apiUrlTestTask.isSuccess()) {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("dialogs", "valid"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("The API URL is valid.", new Object[0]));
                                ValidateApiUrlAction.this.lastTestedUrl = string;
                                ValidateApiUrlAction.this.updateEnabledState();
                            } else {
                                OsmApiUrlInputPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
                                OsmApiUrlInputPanel.this.lblValid.setToolTipText(I18n.tr("Validation failed. The API URL seems to be invalid.", new Object[0]));
                            }
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            };
            Main.worker.submit(runnable);
        }

        protected final void updateEnabledState() {
            boolean bl;
            String string = OsmApiUrlInputPanel.this.getStrippedApiUrl();
            boolean bl2 = bl = !string.isEmpty() && !string.equals(this.lastTestedUrl);
            if (bl) {
                OsmApiUrlInputPanel.this.lblValid.setIcon(null);
            }
            this.setEnabled(bl);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateEnabledState();
        }
    }
}

