/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Cipher;
import org.jruby.ext.openssl.OpenSSL;
import org.jruby.ext.openssl.PKey;
import org.jruby.ext.openssl.SecurityHelper;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.ext.openssl.X509Name;
import org.jruby.ext.openssl.X509Store;
import org.jruby.ext.openssl.impl.BIO;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.MemBIO;
import org.jruby.ext.openssl.impl.Mime;
import org.jruby.ext.openssl.impl.NotVerifiedPKCS7Exception;
import org.jruby.ext.openssl.impl.PKCS7Exception;
import org.jruby.ext.openssl.impl.RecipInfo;
import org.jruby.ext.openssl.impl.SMIME;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.PEMInputOutput;
import org.jruby.ext.openssl.x509store.Store;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"OpenSSL::PKCS7"})
public class PKCS7
extends RubyObject {
    private static final long serialVersionUID = -3925104500966826973L;
    private static ObjectAllocator PKCS7_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new PKCS7(runtime, klass);
        }
    };
    private org.jruby.ext.openssl.impl.PKCS7 p7;

    public static void createPKCS7(Ruby runtime, RubyModule _OpenSSL) {
        RubyClass _PKCS7 = _OpenSSL.defineClassUnder("PKCS7", runtime.getObject(), PKCS7_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _PKCS7.defineClassUnder("PKCS7Error", _OpenSSLError, _OpenSSLError.getAllocator());
        _PKCS7.addReadWriteAttribute(runtime.getCurrentContext(), "data");
        _PKCS7.addReadWriteAttribute(runtime.getCurrentContext(), "error_string");
        _PKCS7.defineAnnotatedMethods(PKCS7.class);
        SignerInfo.createSignerInfo(runtime, (RubyModule)_PKCS7);
        RecipientInfo.createRecipientInfo(runtime, (RubyModule)_PKCS7);
        _PKCS7.setConstant("TEXT", (IRubyObject)runtime.newFixnum(1));
        _PKCS7.setConstant("NOCERTS", (IRubyObject)runtime.newFixnum(2));
        _PKCS7.setConstant("NOSIGS", (IRubyObject)runtime.newFixnum(4));
        _PKCS7.setConstant("NOCHAIN", (IRubyObject)runtime.newFixnum(8));
        _PKCS7.setConstant("NOINTERN", (IRubyObject)runtime.newFixnum(16));
        _PKCS7.setConstant("NOVERIFY", (IRubyObject)runtime.newFixnum(32));
        _PKCS7.setConstant("DETACHED", (IRubyObject)runtime.newFixnum(64));
        _PKCS7.setConstant("BINARY", (IRubyObject)runtime.newFixnum(128));
        _PKCS7.setConstant("NOATTR", (IRubyObject)runtime.newFixnum(256));
        _PKCS7.setConstant("NOSMIMECAP", (IRubyObject)runtime.newFixnum(512));
    }

    public static BIO obj2bio(IRubyObject obj) {
        if (obj instanceof RubyFile) {
            throw obj.getRuntime().newNotImplementedError("TODO: handle RubyFile correctly");
        }
        ByteList str = obj.asString().getByteList();
        return BIO.memBuf(str.getUnsafeBytes(), str.getBegin(), str.getRealSize());
    }

    @Deprecated
    public static PKCS7 wrap(RubyClass klass, org.jruby.ext.openssl.impl.PKCS7 p7) {
        PKCS7 wrapped = new PKCS7(klass.getRuntime(), klass);
        wrapped.p7 = p7;
        return wrapped;
    }

    private static PKCS7 wrap(Ruby runtime, org.jruby.ext.openssl.impl.PKCS7 p7) {
        PKCS7 wrapped = new PKCS7(runtime, PKCS7._PKCS7(runtime));
        wrapped.p7 = p7;
        return wrapped;
    }

    public static IRubyObject membio2str(Ruby runtime, BIO bio) {
        return runtime.newString(new ByteList(((MemBIO)bio).getMemCopy(), false));
    }

    private static List<X509AuxCertificate> getAuxCerts(IRubyObject arg) {
        RubyArray arr = (RubyArray)arg;
        ArrayList<X509AuxCertificate> certs = new ArrayList<X509AuxCertificate>(arr.size());
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            certs.add(((X509Cert)arr.eltInternal(i2)).getAuxCert());
        }
        return certs;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject read_smime(IRubyObject self, IRubyObject arg) {
        Ruby runtime = self.getRuntime();
        BIO in = PKCS7.obj2bio(arg);
        BIO[] out = new BIO[]{null};
        org.jruby.ext.openssl.impl.PKCS7 pkcs7Impl = null;
        try {
            pkcs7Impl = new SMIME(Mime.DEFAULT).readPKCS7(in, out);
        }
        catch (IOException ioe) {
            throw PKCS7.newPKCS7Error(runtime, ioe.getMessage());
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(runtime, pkcs7e);
        }
        if (pkcs7Impl == null) {
            throw PKCS7.newPKCS7Error(runtime, (String)null);
        }
        IRubyObject data = out[0] != null ? PKCS7.membio2str(runtime, out[0]) : runtime.getNil();
        PKCS7 pkcs7 = PKCS7.wrap(runtime, pkcs7Impl);
        pkcs7.setData(data);
        return pkcs7;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject write_smime(IRubyObject self, IRubyObject[] args) {
        Ruby runtime = self.getRuntime();
        IRubyObject data = runtime.getNil();
        IRubyObject flags = runtime.getNil();
        switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)1, (int)3)) {
            case 3: {
                flags = args[2];
            }
            case 2: {
                data = args[1];
            }
        }
        PKCS7 pkcs7 = (PKCS7)args[0];
        int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
        String smime = "";
        try {
            smime = new SMIME().writePKCS7(pkcs7.p7, data.asJavaString(), flg);
        }
        catch (PKCS7Exception e) {
            throw PKCS7.newPKCS7Error(runtime, e);
        }
        catch (IOException e) {
            throw PKCS7.newPKCS7Error(runtime, e.getMessage());
        }
        return RubyString.newString((Ruby)runtime, (String)smime);
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject sign(IRubyObject self, IRubyObject[] args) {
        org.jruby.ext.openssl.impl.PKCS7 pkcs7Impl;
        Ruby runtime = self.getRuntime();
        IRubyObject certs = runtime.getNil();
        IRubyObject flags = runtime.getNil();
        switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)3, (int)5)) {
            case 5: {
                flags = args[4];
            }
            case 4: {
                certs = args[3];
            }
        }
        X509Cert cert2 = (X509Cert)args[0];
        PKey key = (PKey)args[1];
        IRubyObject data = args[2];
        X509AuxCertificate auxCert = cert2.getAuxCert();
        PrivateKey privKey = key.getPrivateKey();
        int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
        BIO dataBIO = PKCS7.obj2bio(data);
        List<X509AuxCertificate> auxCerts = certs.isNil() ? null : PKCS7.getAuxCerts(certs);
        try {
            pkcs7Impl = org.jruby.ext.openssl.impl.PKCS7.sign(auxCert, privKey, auxCerts, dataBIO, flg);
        }
        catch (PKCS7Exception e) {
            throw PKCS7.newPKCS7Error(runtime, e);
        }
        PKCS7 pkcs7 = PKCS7.wrap(runtime, pkcs7Impl);
        pkcs7.setData(data);
        return pkcs7;
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject encrypt(IRubyObject self, IRubyObject[] args) {
        org.jruby.ext.openssl.impl.PKCS7 pkcs7Impl;
        Object c;
        Ruby runtime = self.getRuntime();
        IRubyObject cipher2 = runtime.getNil();
        IRubyObject flags = runtime.getNil();
        switch (Arity.checkArgumentCount((Ruby)self.getRuntime(), (IRubyObject[])args, (int)2, (int)4)) {
            case 4: {
                flags = args[3];
            }
            case 3: {
                cipher2 = args[2];
            }
        }
        IRubyObject data = args[1];
        IRubyObject certs = args[0];
        CipherSpec cipherSpec = null;
        if (cipher2.isNil()) {
            try {
                c = SecurityHelper.getCipher("RC2/CBC/PKCS5Padding");
                cipherSpec = new CipherSpec((javax.crypto.Cipher)c, Cipher.Algorithm.javaToOssl("RC2/CBC/PKCS5Padding", 40), 40);
            }
            catch (GeneralSecurityException e) {
                throw PKCS7.newPKCS7Error(runtime, e);
            }
        } else {
            c = (Cipher)cipher2;
            cipherSpec = new CipherSpec(((Cipher)((Object)c)).getCipherInstance(), ((Cipher)((Object)c)).getName(), ((Cipher)((Object)c)).getGenerateKeyLength() * 8);
        }
        int flg = flags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)flags);
        List<X509AuxCertificate> auxCerts = PKCS7.getAuxCerts(certs);
        byte[] dataBytes = data.asString().getBytes();
        try {
            pkcs7Impl = org.jruby.ext.openssl.impl.PKCS7.encrypt(auxCerts, dataBytes, cipherSpec, flg);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(self.getRuntime(), pkcs7e);
        }
        PKCS7 pkcs7 = PKCS7.wrap(runtime, pkcs7Impl);
        pkcs7.setData(data);
        return pkcs7;
    }

    public PKCS7(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context2, IRubyObject[] args) {
        if (Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)0, (int)1) == 0) {
            this.p7 = new org.jruby.ext.openssl.impl.PKCS7();
            try {
                this.p7.setType(0);
            }
            catch (PKCS7Exception e) {
                throw PKCS7.newPKCS7Error(this.getRuntime(), e);
            }
            return this;
        }
        IRubyObject arg = OpenSSL.to_der_if_possible(context2, args[0]);
        BIO input = PKCS7.obj2bio(arg);
        try {
            this.p7 = org.jruby.ext.openssl.impl.PKCS7.readPEM(input);
            if (this.p7 == null) {
                input.reset();
                this.p7 = org.jruby.ext.openssl.impl.PKCS7.fromASN1(input);
            }
        }
        catch (IllegalArgumentException e) {
            throw this.getRuntime().newArgumentError(e.getMessage());
        }
        catch (IOException ioe) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), ioe.getMessage());
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
        }
        this.setData(this.getRuntime().getNil());
        return this;
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#initialize_copy");
        return this;
    }

    @JRubyMethod(name={"type="})
    public IRubyObject set_type(IRubyObject type) {
        String typeStr = type.toString();
        int typeId = 0;
        if ("signed".equals(typeStr)) {
            typeId = 22;
        } else if ("data".equals(typeStr)) {
            typeId = 21;
        } else if ("signedAndEnveloped".equals(typeStr)) {
            typeId = 24;
        } else if ("enveloped".equals(typeStr)) {
            typeId = 23;
        } else if ("encrypted".equals(typeStr)) {
            typeId = 26;
        }
        try {
            this.p7.setType(typeId);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
        }
        return type;
    }

    @JRubyMethod(name={"type"})
    public IRubyObject get_type() {
        if (this.p7.isSigned()) {
            return this.getRuntime().newSymbol("signed");
        }
        if (this.p7.isEncrypted()) {
            return this.getRuntime().newSymbol("encrypted");
        }
        if (this.p7.isEnveloped()) {
            return this.getRuntime().newSymbol("enveloped");
        }
        if (this.p7.isSignedAndEnveloped()) {
            return this.getRuntime().newSymbol("signedAndEnveloped");
        }
        if (this.p7.isData()) {
            return this.getRuntime().newSymbol("data");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"detached"})
    public IRubyObject detached() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#detached");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"detached="})
    public IRubyObject set_detached(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#detached=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"detached?"})
    public IRubyObject detached_p() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#detached?");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"cipher="})
    public IRubyObject set_cipher(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#cipher=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject add_signer(IRubyObject obj) {
        SignerInfoWithPkey signedInfo = ((SignerInfo)obj).getSignerInfo().dup();
        try {
            this.p7.addSigner(signedInfo);
        }
        catch (PKCS7Exception e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), e);
        }
        if (this.p7.isSigned()) {
            ASN1ObjectIdentifier objectId = org.jruby.ext.openssl.impl.PKCS7.OID_pkcs7_data;
            signedInfo.addSignedAttribute(50, (ASN1Encodable)objectId);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject signers() {
        Collection<SignerInfoWithPkey> signerInfos = this.p7.getSignerInfo();
        RubyArray ary = this.getRuntime().newArray(signerInfos.size());
        for (SignerInfoWithPkey signerInfo : signerInfos) {
            ary.append((IRubyObject)SignerInfo.create(this.getRuntime(), signerInfo));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject add_recipient(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#add_recipient");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject recipients() {
        Collection<RecipInfo> sk = this.p7.isEnveloped() ? this.p7.getEnveloped().getRecipientInfo() : (this.p7.isSignedAndEnveloped() ? this.p7.getSignedAndEnveloped().getRecipientInfo() : null);
        if (sk == null) {
            return this.getRuntime().newArray();
        }
        RubyArray ary = this.getRuntime().newArray(sk.size());
        for (RecipInfo ri : sk) {
            ary.append((IRubyObject)RecipientInfo.create(this.getRuntime(), ri));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject add_certificate(IRubyObject obj) {
        try {
            this.p7.addCertificate(((X509Cert)obj).getAuxCert());
        }
        catch (PKCS7Exception pkcse) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcse);
        }
        return this;
    }

    @JRubyMethod(name={"certificates="})
    public IRubyObject set_certificates(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#certificates=");
        return this.getRuntime().getNil();
    }

    private Collection<X509AuxCertificate> getCertificates() {
        HashSet<X509AuxCertificate> certs;
        int i2 = this.p7.getType();
        switch (i2) {
            case 22: {
                certs = this.p7.getSign().getCert();
                break;
            }
            case 24: {
                certs = this.p7.getSignedAndEnveloped().getCert();
                break;
            }
            default: {
                certs = new HashSet();
            }
        }
        return certs;
    }

    private RubyArray certsToArray(Collection<X509AuxCertificate> certs) throws CertificateEncodingException {
        RubyArray ary = this.getRuntime().newArray(certs.size());
        for (X509AuxCertificate x509 : certs) {
            ary.append(X509Cert.wrap(this.getRuntime(), x509));
        }
        return ary;
    }

    @JRubyMethod
    public IRubyObject certificates() {
        try {
            return this.certsToArray(this.getCertificates());
        }
        catch (CertificateEncodingException cee) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), cee.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject add_crl(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#add_crl");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"crls="})
    public IRubyObject set_crls(IRubyObject obj) {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#crls=");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject crls() {
        OpenSSL.warn(this.getRuntime().getCurrentContext(), "WARNING: unimplemented method called: PKCS7#crls");
        return this.getRuntime().getNil();
    }

    @JRubyMethod(name={"add_data", "data="})
    public IRubyObject add_data(IRubyObject obj) {
        if (this.p7.isSigned()) {
            try {
                this.p7.contentNew(21);
            }
            catch (PKCS7Exception pkcs7e) {
                throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
            }
        }
        BIO in = PKCS7.obj2bio(obj);
        BIO out = null;
        try {
            out = this.p7.dataInit(null);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
        }
        byte[] buf = new byte[4096];
        try {
            int i2;
            while ((i2 = in.read(buf, 0, buf.length)) > 0) {
                if (out == null) continue;
                out.write(buf, 0, i2);
            }
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
        try {
            this.p7.dataFinal(out);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
        }
        this.setData(this.getRuntime().getNil());
        return obj;
    }

    @JRubyMethod(rest=true)
    public IRubyObject verify(IRubyObject[] args) {
        boolean result;
        BIO out;
        Ruby runtime;
        block8: {
            int flg;
            runtime = this.getRuntime();
            IRubyObject indata = runtime.getNil();
            IRubyObject vflags = runtime.getNil();
            switch (Arity.checkArgumentCount((Ruby)runtime, (IRubyObject[])args, (int)2, (int)4)) {
                case 4: {
                    vflags = args[3];
                }
                case 3: {
                    indata = args[2];
                }
            }
            X509Store store = (X509Store)args[1];
            IRubyObject certs = args[0];
            int n = flg = vflags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)vflags);
            if (indata.isNil()) {
                indata = this.getData();
            }
            BIO in = indata.isNil() ? null : PKCS7.obj2bio(indata);
            List<X509AuxCertificate> x509s = certs.isNil() ? null : PKCS7.getAuxCerts(certs);
            Store storeStr = store.getStore();
            out = BIO.mem();
            result = false;
            try {
                this.p7.verify(x509s, storeStr, in, out, flg);
                result = true;
            }
            catch (NotVerifiedPKCS7Exception e) {
            }
            catch (PKCS7Exception pkcs7e) {
                if (!OpenSSL.isDebug(runtime)) break block8;
                pkcs7e.printStackTrace(runtime.getOut());
            }
        }
        IRubyObject data = PKCS7.membio2str(this.getRuntime(), out);
        this.setData(data);
        return result ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(rest=true)
    public IRubyObject decrypt(IRubyObject[] args) {
        IRubyObject dflags = Arity.checkArgumentCount((Ruby)this.getRuntime(), (IRubyObject[])args, (int)2, (int)3) == 3 ? args[2] : this.getRuntime().getNil();
        PKey pkey = (PKey)args[0];
        X509Cert cert2 = (X509Cert)args[1];
        PrivateKey privKey = pkey.getPrivateKey();
        X509AuxCertificate auxCert = cert2.getAuxCert();
        int flg = dflags.isNil() ? 0 : RubyNumeric.fix2int((IRubyObject)dflags);
        BIO out = BIO.mem();
        try {
            this.p7.decrypt(privKey, auxCert, out, flg);
        }
        catch (PKCS7Exception pkcs7e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), pkcs7e);
        }
        return PKCS7.membio2str(this.getRuntime(), out);
    }

    @JRubyMethod(name={"to_pem", "to_s"})
    public IRubyObject to_pem() {
        StringWriter writer = new StringWriter();
        try {
            PEMInputOutput.writePKCS7((Writer)writer, this.p7.toASN1());
            return this.getRuntime().newString(writer.toString());
        }
        catch (IOException e) {
            throw this.getRuntime().newIOErrorFromException(e);
        }
    }

    @JRubyMethod
    public IRubyObject to_der() {
        try {
            return this.getRuntime().newString(new ByteList(this.p7.toASN1(), false));
        }
        catch (IOException e) {
            throw PKCS7.newPKCS7Error(this.getRuntime(), e.getMessage());
        }
    }

    public void setData(IRubyObject object) {
        this.setInstanceVariable("@data", object);
    }

    public IRubyObject getData() {
        return this.getInstanceVariable("@data");
    }

    private static RaiseException newPKCS7Error(Ruby runtime, Exception e) {
        return Utils.newError(runtime, PKCS7._PKCS7(runtime).getClass("PKCS7Error"), e);
    }

    private static RaiseException newPKCS7Error(Ruby runtime, String message) {
        return Utils.newError(runtime, PKCS7._PKCS7(runtime).getClass("PKCS7Error"), message);
    }

    static RubyClass _PKCS7(Ruby runtime) {
        return (RubyClass)runtime.getModule("OpenSSL").getConstant("PKCS7");
    }

    @JRubyClass(name={"OpenSSL::PKCS7::RecipientInfo"})
    public static class RecipientInfo
    extends RubyObject {
        private static final long serialVersionUID = 6977793206950149902L;
        private static ObjectAllocator RECIPIENTINFO_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new RecipientInfo(runtime, klass);
            }
        };
        private RecipInfo info;

        public static void createRecipientInfo(Ruby runtime, RubyModule _PKCS7) {
            RubyClass _Recipient = _PKCS7.defineClassUnder("RecipientInfo", runtime.getObject(), RECIPIENTINFO_ALLOCATOR);
            _Recipient.defineAnnotatedMethods(RecipientInfo.class);
        }

        private static RubyClass _RecipientInfo(Ruby runtime) {
            return PKCS7._PKCS7(runtime).getClass("RecipientInfo");
        }

        public RecipientInfo(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        public static RecipientInfo create(Ruby runtime, RecipInfo info) {
            RecipientInfo instance = new RecipientInfo(runtime, RecipientInfo._RecipientInfo(runtime));
            instance.info = info;
            return instance;
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject arg) {
            OpenSSL.warn(context2, "WARNING: unimplemented method called: recipientInfo#initialize");
            return this;
        }

        @JRubyMethod
        public IRubyObject issuer() {
            return X509Name.newName(this.getRuntime(), this.info.getIssuerAndSerial().getName());
        }

        @JRubyMethod
        public IRubyObject serial() {
            return RubyBignum.bignorm((Ruby)this.getRuntime(), (BigInteger)this.info.getIssuerAndSerial().getCertificateSerialNumber().getValue());
        }

        @JRubyMethod
        public IRubyObject enc_key(ThreadContext context2) {
            OpenSSL.warn(context2, "WARNING: unimplemented method called: recipientInfo#enc_key");
            return context2.runtime.getNil();
        }
    }

    @JRubyClass(name={"OpenSSL::PKCS7::SignerInfo"})
    public static class SignerInfo
    extends RubyObject {
        private static final long serialVersionUID = -3799397032272738848L;
        private static ObjectAllocator SIGNERINFO_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new SignerInfo(runtime, klass);
            }
        };
        private SignerInfoWithPkey info;

        public static void createSignerInfo(Ruby runtime, RubyModule _PKCS7) {
            RubyClass _SignerInfo = _PKCS7.defineClassUnder("SignerInfo", runtime.getObject(), SIGNERINFO_ALLOCATOR);
            _PKCS7.defineConstant("Signer", (IRubyObject)_SignerInfo);
            _SignerInfo.defineAnnotatedMethods(SignerInfo.class);
        }

        private static RubyClass _SignerInfo(Ruby runtime) {
            return PKCS7._PKCS7(runtime).getClass("SignerInfo");
        }

        public static SignerInfo create(Ruby runtime, SignerInfoWithPkey info) {
            SignerInfo instance = new SignerInfo(runtime, SignerInfo._SignerInfo(runtime));
            instance.info = info;
            return instance;
        }

        public SignerInfo(Ruby runtime, RubyClass type) {
            super(runtime, type);
        }

        SignerInfoWithPkey getSignerInfo() {
            return this.info;
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public IRubyObject initialize(ThreadContext context2, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
            OpenSSL.warn(context2, "WARNING: unimplemented method called: signerInfo#initialize");
            return this;
        }

        @JRubyMethod(name={"issuer", "name"})
        public IRubyObject issuer() {
            return X509Name.newName(this.getRuntime(), this.info.getIssuerAndSerialNumber().getName());
        }

        @JRubyMethod
        public IRubyObject serial() {
            return RubyBignum.bignorm((Ruby)this.getRuntime(), (BigInteger)this.info.getIssuerAndSerialNumber().getCertificateSerialNumber().getValue());
        }

        @JRubyMethod
        public IRubyObject signed_time(ThreadContext context2) {
            OpenSSL.warn(context2, "WARNING: unimplemented method called: signerInfo#signed_time");
            return context2.runtime.getNil();
        }
    }
}

