/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.publish;

import com.google.common.base.Function;
import com.netflix.servo.Metric;
import com.netflix.servo.publish.MetricObserver;
import java.util.ArrayList;
import java.util.List;

public class MetricTransformObserver
implements MetricObserver {
    private final Function<Metric, Metric> transformer;
    private final MetricObserver observer;

    public MetricTransformObserver(Function<Metric, Metric> transformer, MetricObserver observer) {
        this.transformer = transformer;
        this.observer = observer;
    }

    @Override
    public void update(List<Metric> metrics) {
        ArrayList<Metric> transformed = new ArrayList<Metric>(metrics.size());
        for (Metric m : metrics) {
            transformed.add((Metric)this.transformer.apply((Object)m));
        }
        this.observer.update(transformed);
    }

    @Override
    public String getName() {
        return "MetricTransformObserver";
    }
}

