/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui.midi;

import common.Midi;
import common.Util;
import dguitar.gui.DGuitar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiDevices
extends JDialog
implements ActionListener,
ListSelectionListener {
    private JButton btnSetDevice;
    private JButton btnCancel;
    private int currentIndex;
    private static Midi midi;
    private JPanel btnPanel;
    private Frame parent;
    private String mdc;
    private static JList midiDevices;

    public MidiDevices(Frame parent, boolean modal, Midi m, String midiDeviceConfigured) {
        super(parent, modal);
        midi = m;
        this.mdc = midiDeviceConfigured;
        this.initComponents();
        this.postInit();
    }

    private void setMidiDevices(Object[] array) {
        midiDevices.setListData(array);
    }

    private void setCurrentMidiDevice(int i) {
        this.currentIndex = i;
        midiDevices.setSelectedIndex(i);
        this.btnSetDevice.setEnabled(false);
        this.btnSetDevice.setText(DGuitar.getLang().getString("isCurrentMidiDevice"));
    }

    private void postInit() {
        this.btnPanel = new JPanel(new BorderLayout());
        this.btnCancel = new JButton();
        this.btnCancel.setText(DGuitar.getLang().getString("menuClose"));
        this.btnCancel.addActionListener(this);
        this.btnSetDevice = new JButton();
        this.btnSetDevice.setText(DGuitar.getLang().getString("setMidiDevice"));
        this.btnSetDevice.addActionListener(this);
        this.btnPanel.add((Component)this.btnSetDevice, "Center");
        midiDevices.addListSelectionListener(this);
        this.setTitle(DGuitar.getLang().getString("menuMidiDevices"));
        this.setMidiDevices(midi.getMidiDevices());
        this.setCurrentMidiDevice(midi.getCurrentDeviceIndex());
        this.btnPanel.add((Component)this.btnCancel, "South");
        this.getContentPane().add((Component)this.btnPanel, "South");
    }

    private void initComponents() {
        midiDevices = new JList();
        this.setDefaultCloseOperation(2);
        midiDevices.setSelectionMode(0);
        this.getContentPane().add((Component)midiDevices, "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 300) / 2, 400, 300);
    }

    public void actionPerformed(ActionEvent e) {
        JButton btn = (JButton)e.getSource();
        if (btn.equals(this.btnSetDevice)) {
            int aux = midiDevices.getSelectedIndex();
            boolean success = midi.setCurrentDevice(aux, DGuitar.getLang().getString("doesNotHaveAnyReceivers"));
            if (success) {
                this.setCurrentMidiDevice(aux);
                Util.showDialogOk(this.parent, this.mdc, midi.deviceMessage(DGuitar.getLang().getString("MidiDevice"), DGuitar.getLang().getString("isNowPreferredDevice")));
            }
        } else {
            this.dispose();
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        int aux = midiDevices.getSelectedIndex();
        if (aux == this.currentIndex) {
            this.btnSetDevice.setEnabled(false);
            this.btnSetDevice.setText(DGuitar.getLang().getString("isCurrentMidiDevice"));
        } else {
            this.btnSetDevice.setText(DGuitar.getLang().getString("setMidiDevice"));
            this.btnSetDevice.setEnabled(true);
        }
    }
}

