/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.shape.Point;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class PointBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.POINT;
    private Coordinate coordinate;

    public PointBuilder coordinate(Coordinate coordinate) {
        this.coordinate = coordinate;
        return this;
    }

    public double longitude() {
        return this.coordinate.x;
    }

    public double latitude() {
        return this.coordinate.y;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", PointBuilder.TYPE.shapename);
        builder.field("coordinates");
        PointBuilder.toXContent(builder, this.coordinate);
        return builder.endObject();
    }

    public Point build() {
        return SPATIAL_CONTEXT.makePoint(this.coordinate.x, this.coordinate.y);
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }
}

