

  {extends file="main.tpl"}
    <!DOCTYPE head PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><head xmlns="http://www.w3.org/1999/xhtml">
  {block name=title}GPSBabel development:Manipulate track lists (track){/block}
  {block name=body}
                       
  <div xmlns="http://www.w3.org/1999/xhtml" class="navheader"><table width="100%" summary="Navigation header"><tr><th colspan="3" align="center">Manipulate track lists (track)</th></tr><tr><td width="20%" align="left"><a accesskey="p" href="filter_height.html">Prev</a> </td><th width="60%" align="center">Chapter 4. Data Filters</th><td width="20%" align="right"> <a accesskey="n" href="filter_sort.html">Next</a></td></tr></table><hr /></div><div xmlns="http://www.w3.org/1999/xhtml" class="section"><div class="titlepage"><div><div><h2 class="title" ><a id="filter_track"></a>Manipulate track lists (track)</h2></div></div></div><p>
WARNING: This filter always drops empty tracks.
</p><p>
This filter performs various operations on track data.
</p><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_move"></a>move option</h3></div></div></div><p>
      Correct trackpoint timestamps by a delta.
    </p><p>
This option changes the time of all trackpoints. This might be useful if
your track must be moved by one or more hours because of an incorrect
time zone.
</p><div class="example"><a id="ex_track_move"></a><p class="title"><strong>Example 4.8. Time-shifting a track with the track filter</strong></p><div class="example-contents"><p>
The following command line will shift all tracks to be one hour later.
</p><p><strong class="userinput"><code>gpsbabel -t -i gpx -f in.gpx -x track,move=+1h -o gpx -F out.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_pack"></a>pack option</h3></div></div></div><p>
      Pack all tracks into one.
    </p><p> 
This option causes all tracks to be appended to one another to form a single
track.  This option does not work if any two tracks overlap in time; in that
case, consider using the <code class="option">merge</code> option. 
</p><p>
This option is most useful for rejoining tracks that might have
been interrupted by an equipment malfunction or an overnight stop.
</p><p>
If no other option is given to the track filter, this option is assumed.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_split"></a>split option</h3></div></div></div><p>
      Split by date or time interval (see README).
    </p><p> The input track will be split into several tracks
         depending on date of track points. If there is more than one
         track, use the pack option before before using this.  To
         split a single tracks into separate tracks for each day and
         name them, use this:
      </p><p><strong class="userinput"><code> gpsbabel -t -i gpx -f in.gpx -x track,split,title="ACTIVE LOG # %Y%m%d" -o gpx -F out.gpx</code></strong></p><p> If the input has multiple tracks, pack them together before
splitting them back apart per day thusly: </p><p><strong class="userinput"><code>     	    gpsbabel -t   -i gpx -f in.gpx  
     -x track,pack,split,title="ACTIVE LOG # %D"  	
     -o gpx -F out.gpx</code></strong></p><p> Additionally you can add an interval to the split
         option.  With this the track will be split if the time
         between two points is greater than this parameter. The
         interval must be numeric and can be int days, hours, minutes
         or seconds, expressed as one of the character "d", "h", "m",
         or "s".  If no trailing character is present, the units are
         assumed to be in seconds.
</p><p> For example, to split a track based on an four hour
         interval, use this:</p><p><strong class="userinput"><code>            
gpsbabel -t 
     -i gpx -f in.gpx 
     -x track,pack,split=4h,title="LOG # %c" 
     -o gpx -F out.gpx
</code></strong></p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_sdistance"></a>sdistance option</h3></div></div></div><p>
      Split by distance.
    </p><p> The input track will be split into several tracks
         if the distance between successive track points
         is greater than the distance given as a parameter.
         The distance must be numeric and can be in miles or kilometers,
         expressed as one of the character "k", or "m".
	If sdistance is given no parameters, this option has the same 
	effect as the split option without parameters. If there is more 
	than one track,
         use the pack option before before using this.</p><p> For example, to split the track if the distance between
         points is greater than 100 meters, use this:</p><p><strong class="userinput"><code>
gpsbabel -t 
     -i gpx -f in.gpx 
     -x track,pack,sdistance=0.1k" 
     -o gpx -F out.gpx
</code></strong></p><p> The sdistance option can be combined with the split option.
        The track then will be split only if both time and distance
        interval exceeds the supplied values. This technique can be used to 
	filter out gaps from
        the tracklog.  The gap is kept only if the gps device is without
        signal for longer time than that given and during that time it moves 
	a distance over that given.
        This example splits the track
        if the device is without signal for at least 5 minutes
        and during this time moves more than 300 meters:</p><p><strong class="userinput"><code>
gpsbabel -t 
     -i gpx -f in.gpx 
     -x track,pack,sdistance=0.3k,split=5m 
     -o gpx -F out.gpx
</code></strong></p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_merge"></a>merge option</h3></div></div></div><p>
      Merge multiple tracks for the same way.
    </p><p> 
This option puts all track points from all tracks into a single track 
and sorts them by time stamp.  Points with identical time stamps will be
dropped.
</p><div class="example"><a id="ex_track_merge"></a><p class="title"><strong>Example 4.9. Merging tracks with the track filter</strong></p><div class="example-contents"><p> 
Suppose you want to merge tracks recorded with two different GPS devices 
at the same time.  To do that, use this command line:
</p><p><strong class="userinput"><code>gpsbabel -t -i gpx -f john.gpx -i gpx -f doe.gpx -x track,merge,title="COMBINED LOG" -o gpx -F john_doe.gpx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_name"></a>name option</h3></div></div></div><p>
      Use only track(s) where title matches given name.
    </p><p>
With the name option you can filter out a track by title.
</p><p>
The comparison is always non-case-sensitive. Wildcards are allowed.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_start"></a>start option</h3></div></div></div><p>
      Use only track points after this timestamp.
    </p><p>
This option is used along with the <code class="option">stop</code> to discard 
trackpoints that were recorded outside of a specific period of time.  
This option specifies the beginning of the time period.
</p><p>
If this option is not specified, the time period is assumed to begin at the
dawn of time or January 1, 1970, whichever was later.  The time for this 
option is expressed in UTC. 
</p><p>
The value of this option must be in the form of YYYYMMDDHHMMSS, but it is
not necessary to specify the smaller time units if they are not needed.  
That is, if you only care about points logged between 10 AM and 6 PM on a
given date, you need not specify the minutes or seconds.
</p><div class="example"><a id="ex_track_startstop"></a><p class="title"><strong>Example 4.10. Extracting a period of time with the track filter</strong></p><div class="example-contents"><p>
To get only the parts of a track that were mapped on 20 July 2005
between 10 AM and 6 PM, use this command line:
</p><p><strong class="userinput"><code>gpsbabel -t -i gpx -f in.gpx -x track,start=2005072010,stop=2005072018 -o gpx -F out.gpx </code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_stop"></a>stop option</h3></div></div></div><p>
      Use only track points before this timestamp.
    </p><p>
This option is used in conjunction with the <code class="option">start</code> option to 
discard all trackpoints outside of a given period of time.  This option 
defines the end of the time period.
</p><p>
If this option is not specified, the time period is assumed to end at the 
end of civilization as we know it or the year 2038, whichever comes first.
The time for this option is expressed in UTC.
</p><p>
See the <code class="option">start</code> option for the format of this value and an 
example of usage.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_title"></a>title option</h3></div></div></div><p>
      Basic title for new track(s).
    </p><p> 
This option specifies a title for tracks generated by the track filter.
By default, the title of the new track is composed of the start time of 
the track appended to this value.
</p><p>
If this value contains a percent (%) character, it is treated as a format 
string for the POSIX strftime function, allowing custom time-based 
track names. 
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_fix"></a>fix option</h3></div></div></div><p>
      Synthesize GPS fixes (PPS, DGPS, 3D, 2D, NONE).
    </p><p>
This option sets the GPS fix status for all trackpoints to the specified
value.  Valid values for this option are PPS, DGPS, 3D, 2D, or NONE.
</p><p>
This option is most useful when converting from a format that doesn't 
contain GPS fix status to one that requires it.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_course"></a>course option</h3></div></div></div><p>
      Synthesize course.
    </p><p>
This option computes (or recomputes) a value for the GPS heading at each 
trackpoint.  This is most useful with trackpoints from formats that don't 
support heading information or for trackpoints synthesized by the 
<a class="link" href="filter_interpolate.html" title="Interpolate between trackpoints (interpolate)">interpolate</a>
filter.  The heading at each trackpoint is simply the course from the
previous trackpoint in the track.  The first trackpoint in each track
is arbitrarily assigned a heading of 0 degrees.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_speed"></a>speed option</h3></div></div></div><p>
      Synthesize speed.
    </p><p>
This option computes a value for the GPS speed at each trackpoint.
This is most useful with trackpoints from formats that don't support
speed information or for trackoints synthesized by the 
<a class="link" href="filter_interpolate.html" title="Interpolate between trackpoints (interpolate)">interpolate</a>
filter.  The speed at each trackpoint is the average speed from the
previous trackpoint (distance divided by time).  The first trackpoint 
in each track is assigned a speed of "unknown."
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_seg2trk"></a>seg2trk option</h3></div></div></div><p>
      Split track at segment boundaries into multiple tracks.
    </p><p>
This option splits tracks at segment boundaries into multiple tracks. This
is useful to restore the behaviour of GPSBabel versions up to 1.3.6 which
didn't support track segment markers and automatically put each segment into
a separate track.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_trk2seg"></a>trk2seg option</h3></div></div></div><p>
      Merge tracks inserting segment separators at boundaries.
    </p><p>
This option merges multiple tracks, inserting segment separators at
track boundaries. It expects the tracks to already be in the right order for
merging, i.e. it does not check timestamps and reorder track points so that
their timestamps are monotonically increasing.
</p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_segment"></a>segment option</h3></div></div></div><p>
      segment tracks with abnormally long gaps.
    </p></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_faketime"></a>faketime option</h3></div></div></div><p>
      Add specified timestamp to each trackpoint.
    </p><p>
This option assigns a time value to each trackpoint.
</p><p>
The value of this option must be in the form of fYYYYMMDDHHMMSS+SS.
</p><p>
The parameter f (force) is optional and means that the time value of each trackpoint is replaced.
If f is not specified, the time value of each trackpoint is only replaced when the trackpoint contains no time value.
</p><p>
YYYYMMDDHHMMSS is the pattern for the timestamp and is required.
</p><p>
The plus sign is the delimiter between the timestamp and the step time in seconds.
The first trackpoint receives the time value of the timestamp and
each following trackpoint receives the timestamp incremented by the step time.
The specification of the steptime is optional.
</p><p>
The parameter was added because some software products (e.g. garmin training center)
require a time value for each trackpoint.
</p><div class="example"><a id="ex_track_faketime1"></a><p class="title"><strong>Example 4.11. Replace time values of a track</strong></p><div class="example-contents"><p>
Replace all time values with new time values.
Start at the 5 th of July, 2010 at 8 PM and
increment 2 seconds between each trackpoint:
</p><p><strong class="userinput"><code>gpsbabel -i kml -f in.kml -x track,faketime=f20100705200000+2 -o gtrnctr -F out.tcx</code></strong></p></div></div><br class="example-break" /><div class="example"><a id="ex_track_faketime2"></a><p class="title"><strong>Example 4.12. Add time values to a track</strong></p><div class="example-contents"><p>
Add a time value to a trackpoint, if the trackpoint contains no time value.
Start at the 6 th of May, 2010 at 6 AM and
increment 5 seconds between each trackpoint:
</p><p><strong class="userinput"><code>gpsbabel -i kml -f in.kml -x track,faketime=20100506060000+5 -o gtrnctr -F out.tcx</code></strong></p></div></div><br class="example-break" /></div><div class="section"><div class="titlepage"><div><div><h3 class="title"><a id="fmt_track_o_discard"></a>discard option</h3></div></div></div><p>
      Discard track points without timestamps during merge.
    </p><p> 
This option is used in conjunction with the merge option to discard track points with missing
timestamps instead of aborting with the "Found track point at lat,lon without time!" error.
</p><div class="example"><a id="ex_track_discard"></a><p class="title"><strong>Example 4.13. Merging tracks with missing timestamps with the track filter</strong></p><div class="example-contents"><p> 
Suppose you want to merge tracks that may have missing timestamps.  To do that, use this command line:
</p><p><strong class="userinput"><code>gpsbabel -t -i gpx -f john.gpx -f doe.gpx -x track,merge,discard -o gpx -F john_doe.gpx</code></strong></p></div></div><br class="example-break" /></div></div><div xmlns="http://www.w3.org/1999/xhtml" class="navfooter"><hr /><table width="100%" summary="Navigation footer"><tr><td width="40%" align="left"><a accesskey="p" href="filter_height.html">Prev</a> </td><td width="20%" align="center"><a accesskey="u" href="Data_Filters.html">Up</a></td><td width="40%" align="right"> <a accesskey="n" href="filter_sort.html">Next</a></td></tr><tr><td width="40%" align="left" valign="top">Manipulate altitudes (height) </td><td width="20%" align="center"><a accesskey="h" href="index.html">Home</a></td><td width="40%" align="right" valign="top"> Rearrange waypoints by resorting (sort)</td></tr></table></div>
  
      {/block}
  