/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationQueueFactory;
import org.gradle.internal.operations.BuildOperationQueueFailure;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOperationProcessor
implements BuildOperationProcessor,
Stoppable {
    private static final String LINE_SEPARATOR = SystemProperties.getInstance().getLineSeparator();
    private final BuildOperationQueueFactory buildOperationQueueFactory;
    private final StoppableExecutor fixedSizePool;

    public DefaultBuildOperationProcessor(BuildOperationQueueFactory buildOperationQueueFactory, ExecutorFactory executorFactory, int maxWorkerCount) {
        this.buildOperationQueueFactory = buildOperationQueueFactory;
        this.fixedSizePool = executorFactory.create("build operations", maxWorkerCount);
    }

    @Override
    public <T extends BuildOperation> void run(BuildOperationWorker<T> worker, Action<BuildOperationQueue<T>> generator) {
        BuildOperationQueue<T> queue = this.buildOperationQueueFactory.create(this.fixedSizePool, worker);
        ArrayList failures = Lists.newArrayList();
        try {
            generator.execute(queue);
        }
        catch (Exception e) {
            failures.add(new BuildOperationQueueFailure("There was a failure while populating the build operation queue: " + e.getMessage(), e));
            queue.cancel();
        }
        try {
            queue.waitForCompletion();
        }
        catch (MultipleBuildOperationFailures e) {
            failures.add(e);
        }
        if (failures.size() == 1) {
            throw (GradleException)failures.get(0);
        }
        if (failures.size() > 1) {
            throw new DefaultMultiCauseException(DefaultBuildOperationProcessor.formatMultipleFailureMessage(failures), failures);
        }
    }

    @Override
    public <T extends RunnableBuildOperation> void run(Action<BuildOperationQueue<T>> generator) {
        BuildOperationWorker runnableWorker = new BuildOperationWorker<T>(){

            @Override
            public String getDisplayName() {
                return "runnable worker";
            }

            @Override
            public void execute(T t) {
                t.run();
            }
        };
        this.run(runnableWorker, generator);
    }

    @Override
    public void stop() {
        this.fixedSizePool.stop();
    }

    private static String formatMultipleFailureMessage(List<GradleException> failures) {
        return StringUtils.join(CollectionUtils.collect(failures, new Transformer<String, GradleException>(){

            @Override
            public String transform(GradleException e) {
                return e.getMessage();
            }
        }), (String)(LINE_SEPARATOR + "AND" + LINE_SEPARATOR));
    }
}

