/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverlappingDirectoriesDetector {
    private final char fileSeparatorChar;
    TreeNode rootNode = new TreeNode("", null);
    List<TreeNode> leafs = new ArrayList<TreeNode>();

    public OverlappingDirectoriesDetector() {
        this(File.separatorChar);
    }

    public OverlappingDirectoriesDetector(char fileSeparatorChar) {
        this.fileSeparatorChar = fileSeparatorChar;
    }

    public void addPaths(Collection<String> outputPaths) {
        for (String path : outputPaths) {
            String[] pathParts = StringUtils.split((String)path, (char)this.fileSeparatorChar);
            TreeNode current = this.rootNode.addChild(pathParts[0]);
            for (int i = 1; i < pathParts.length; ++i) {
                current = current.addChild(pathParts[i]);
            }
            current.increaseLeafCounter(path);
            this.leafs.add(current);
        }
    }

    public Collection<String> resolveOverlappingPaths() {
        HashSet<String> overlappingPaths = new HashSet<String>();
        for (TreeNode leaf : this.leafs) {
            List<TreeNode> overlappingNodes = leaf.findOverlapping();
            if (overlappingNodes.size() > 0 || leaf.leafCounter > 1) {
                overlappingPaths.add(leaf.getLeafPath());
            }
            for (TreeNode overlappingNode : overlappingNodes) {
                overlappingPaths.add(overlappingNode.getLeafPath());
            }
        }
        return overlappingPaths;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeNode {
        private final String segment;
        private final TreeNode parent;
        List<TreeNode> children = new ArrayList<TreeNode>();
        int leafCounter;
        String leafPath;

        private TreeNode(String segment, TreeNode parent) {
            this.segment = segment;
            this.parent = parent;
        }

        public TreeNode addChild(String pathPart) {
            for (TreeNode child : this.children) {
                if (!child.segment.equals(pathPart)) continue;
                return child;
            }
            TreeNode newRoot = new TreeNode(pathPart, this);
            this.children.add(newRoot);
            return newRoot;
        }

        public void increaseLeafCounter(String leafPath) {
            ++this.leafCounter;
            this.leafPath = leafPath;
        }

        public String getLeafPath() {
            return this.leafPath;
        }

        public boolean hasLeafs() {
            return this.leafCounter > 0;
        }

        public List<TreeNode> findOverlapping() {
            LinkedList<TreeNode> overlappingNodes = new LinkedList<TreeNode>();
            TreeNode current = this.parent;
            while (current != null) {
                if (current.hasLeafs()) {
                    overlappingNodes.add(current);
                }
                current = current.parent;
            }
            return overlappingNodes;
        }
    }
}

