/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.locklistener;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.FileLockCommunicator;
import org.gradle.cache.internal.GracefullyStoppedException;
import org.gradle.cache.internal.locklistener.FileLockContentionHandler;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.concurrent.StoppableExecutor;
import org.gradle.internal.remote.internal.inet.InetAddressFactory;

public class DefaultFileLockContentionHandler
implements FileLockContentionHandler,
Stoppable {
    private static final Logger LOGGER = Logging.getLogger(DefaultFileLockContentionHandler.class);
    private final Lock lock = new ReentrantLock();
    private final Map<Long, Runnable> contendedActions = new HashMap<Long, Runnable>();
    private final ExecutorFactory executorFactory;
    private final InetAddressFactory addressFactory;
    private FileLockCommunicator communicator;
    private StoppableExecutor executor;
    private boolean stopped;

    public DefaultFileLockContentionHandler(ExecutorFactory executorFactory, InetAddressFactory addressFactory) {
        this.executorFactory = executorFactory;
        this.addressFactory = addressFactory;
    }

    private Runnable listener() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LOGGER.debug("Starting file lock listener thread.");
                    this.doRun();
                }
                catch (Throwable t) {
                    LOGGER.error("Problems handling incoming cache access requests.", t);
                }
                finally {
                    LOGGER.debug("File lock listener thread completed.");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void doRun() {
                while (true) {
                    Runnable action;
                    long lockId;
                    try {
                        lockId = DefaultFileLockContentionHandler.this.communicator.receive();
                    }
                    catch (GracefullyStoppedException e) {
                        return;
                    }
                    DefaultFileLockContentionHandler.this.lock.lock();
                    try {
                        action = (Runnable)DefaultFileLockContentionHandler.this.contendedActions.get(lockId);
                        if (action == null) {
                            continue;
                        }
                    }
                    finally {
                        DefaultFileLockContentionHandler.this.lock.unlock();
                        continue;
                    }
                    action.run();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long lockId, Runnable whenContended) {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                throw new IllegalStateException("Must initialize the handler by reserving the port first.");
            }
            if (this.executor == null) {
                this.executor = this.executorFactory.create("File lock request listener");
                this.executor.execute(this.listener());
            }
            if (this.contendedActions.containsKey(lockId)) {
                throw new UnsupportedOperationException("Multiple contention actions for a given lock are currently not supported.");
            }
            this.contendedActions.put(lockId, whenContended);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void pingOwner(int port, long lockId, String displayName) {
        this.getCommunicator().pingOwner(port, lockId, displayName);
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot start managing file contention because this handler has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long lockId) {
        this.lock.lock();
        try {
            this.contendedActions.remove(lockId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.lock.lock();
        try {
            this.stopped = true;
            this.contendedActions.clear();
            if (this.communicator != null) {
                this.communicator.stop();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.executor != null) {
            this.executor.stop();
        }
    }

    public int reservePort() {
        return this.getCommunicator().getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileLockCommunicator getCommunicator() {
        this.lock.lock();
        try {
            this.assertNotStopped();
            if (this.communicator == null) {
                this.communicator = new FileLockCommunicator(this.addressFactory);
            }
            FileLockCommunicator fileLockCommunicator = this.communicator;
            return fileLockCommunicator;
        }
        finally {
            this.lock.unlock();
        }
    }
}

