/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.idea.model;

import com.google.common.collect.Sets;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.PathFactory;
import org.gradle.plugins.ide.idea.model.Project;
import org.gradle.plugins.ide.idea.model.ProjectLibrary;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaProject
extends GroovyObjectSupport {
    private final org.gradle.api.Project project;
    private final XmlFileContentMerger ipr;
    private List<IdeaModule> modules;
    private String jdkName;
    private IdeaLanguageLevel languageLevel;
    private JavaVersion targetBytecodeVersion;
    private String vcs;
    private Set<String> wildcards;
    private File outputFile;
    private Set<ProjectLibrary> projectLibraries = Sets.newLinkedHashSet();
    private PathFactory pathFactory;

    public IdeaProject(org.gradle.api.Project project, XmlFileContentMerger ipr) {
        this.project = project;
        this.ipr = ipr;
    }

    public org.gradle.api.Project getProject() {
        return this.project;
    }

    public XmlFileContentMerger getIpr() {
        return this.ipr;
    }

    public void ipr(Closure<XmlFileContentMerger> closure) {
        ConfigureUtil.configure(closure, (Object)((Object)this.getIpr()));
    }

    public String getName() {
        return this.getOutputFile().getName().replaceFirst("\\.ipr$", "");
    }

    public List<IdeaModule> getModules() {
        return this.modules;
    }

    public void setModules(List<IdeaModule> modules) {
        this.modules = modules;
    }

    public String getJdkName() {
        return this.jdkName;
    }

    public void setJdkName(String jdkName) {
        this.jdkName = jdkName;
    }

    public IdeaLanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public void setLanguageLevel(Object languageLevel) {
        this.languageLevel = new IdeaLanguageLevel(languageLevel);
    }

    @Incubating
    public JavaVersion getTargetBytecodeVersion() {
        return this.targetBytecodeVersion;
    }

    @Incubating
    public void setTargetBytecodeVersion(JavaVersion targetBytecodeVersion) {
        this.targetBytecodeVersion = targetBytecodeVersion;
    }

    @Incubating
    public String getVcs() {
        return this.vcs;
    }

    @Incubating
    public void setVcs(String vcs) {
        this.vcs = vcs;
    }

    public Set<String> getWildcards() {
        return this.wildcards;
    }

    public void setWildcards(Set<String> wildcards) {
        this.wildcards = wildcards;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    @Incubating
    public Set<ProjectLibrary> getProjectLibraries() {
        return this.projectLibraries;
    }

    @Incubating
    public void setProjectLibraries(Set<ProjectLibrary> projectLibraries) {
        this.projectLibraries = projectLibraries;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public void setPathFactory(PathFactory pathFactory) {
        this.pathFactory = pathFactory;
    }

    public void mergeXmlProject(Project xmlProject) {
        this.ipr.getBeforeMerged().execute((Object)xmlProject);
        xmlProject.configure(this.getModules(), this.getJdkName(), this.getLanguageLevel(), this.getTargetBytecodeVersion(), this.getWildcards(), this.getProjectLibraries(), this.getVcs());
        this.ipr.getWhenMerged().execute((Object)xmlProject);
    }
}

