/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeProjectDirectoryMapper;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.Dependency;
import org.gradle.plugins.ide.idea.model.IdeaLanguageLevel;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;
import org.gradle.plugins.ide.idea.model.ModuleDependency;
import org.gradle.plugins.ide.idea.model.SingleEntryModuleLibrary;
import org.gradle.plugins.ide.internal.tooling.GradleProjectBuilder;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaCompilerOutput;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaContentRoot;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaDependencyScope;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaJavaLanguageSettings;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaLanguageLevel;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModule;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaModuleDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaProject;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSingleEntryLibraryDependency;
import org.gradle.plugins.ide.internal.tooling.idea.DefaultIdeaSourceDirectory;
import org.gradle.plugins.ide.internal.tooling.java.DefaultInstalledJdk;
import org.gradle.tooling.internal.gradle.DefaultGradleModuleVersion;
import org.gradle.tooling.internal.gradle.DefaultGradleProject;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaModelBuilder
implements ToolingModelBuilder {
    private final GradleProjectBuilder gradleProjectBuilder;
    private final CompositeProjectDirectoryMapper compositeProjectMapper;
    private boolean offlineDependencyResolution;

    public IdeaModelBuilder(GradleProjectBuilder gradleProjectBuilder, ServiceRegistry services) {
        this.gradleProjectBuilder = gradleProjectBuilder;
        this.compositeProjectMapper = new CompositeProjectDirectoryMapper(services);
    }

    public boolean canBuild(String modelName) {
        return modelName.equals("org.gradle.tooling.model.idea.IdeaProject");
    }

    public DefaultIdeaProject buildAll(String modelName, Project project) {
        Project root = project.getRootProject();
        this.applyIdeaPlugin(root);
        DefaultGradleProject rootGradleProject = this.gradleProjectBuilder.buildAll(project);
        return this.build(root, rootGradleProject);
    }

    private void applyIdeaPlugin(Project root) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            p.getPluginManager().apply(IdeaPlugin.class);
        }
        this.ideaPluginFor(root).makeSureModuleNamesAreUnique();
    }

    private DefaultIdeaProject build(Project project, DefaultGradleProject rootGradleProject) {
        IdeaModel ideaModel = this.ideaPluginFor(project).getModel();
        IdeaProject projectModel = ideaModel.getProject();
        JavaVersion projectSourceLanguageLevel = this.convertIdeaLanguageLevelToJavaVersion(projectModel.getLanguageLevel());
        JavaVersion projectTargetBytecodeLevel = projectModel.getTargetBytecodeVersion();
        DefaultIdeaProject out = new DefaultIdeaProject().setName(projectModel.getName()).setJdkName(projectModel.getJdkName()).setLanguageLevel(new DefaultIdeaLanguageLevel(projectModel.getLanguageLevel().getLevel())).setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(projectSourceLanguageLevel).setTargetBytecodeVersion(projectTargetBytecodeLevel).setJdk(DefaultInstalledJdk.current()));
        HashMap<String, DefaultIdeaModule> modules = new HashMap<String, DefaultIdeaModule>();
        for (IdeaModule module : projectModel.getModules()) {
            this.appendModule(modules, module, out, rootGradleProject);
        }
        for (IdeaModule module : projectModel.getModules()) {
            this.buildDependencies(modules, module);
        }
        Collection ideaModules = modules.values();
        out.setChildren(new LinkedList(ideaModules));
        return out;
    }

    private IdeaPlugin ideaPluginFor(Project project) {
        return (IdeaPlugin)project.getPlugins().getPlugin(IdeaPlugin.class);
    }

    private void buildDependencies(Map<String, DefaultIdeaModule> modules, IdeaModule ideaModule) {
        ideaModule.setOffline(this.offlineDependencyResolution);
        Set<Dependency> resolved = ideaModule.resolveDependencies();
        LinkedList<DefaultIdeaDependency> dependencies = new LinkedList<DefaultIdeaDependency>();
        for (Dependency dependency : resolved) {
            GroovyObjectSupport d;
            if (dependency instanceof SingleEntryModuleLibrary) {
                d = (SingleEntryModuleLibrary)dependency;
                DefaultIdeaSingleEntryLibraryDependency defaultDependency = new org.gradle.tooling.internal.idea.DefaultIdeaSingleEntryLibraryDependency().setFile(d.getLibraryFile()).setSource(d.getSourceFile()).setJavadoc(d.getJavadocFile()).setScope(new DefaultIdeaDependencyScope(d.getScope())).setExported(d.isExported());
                if (d.getModuleVersion() != null) {
                    defaultDependency.setGradleModuleVersion((GradleModuleVersion)new DefaultGradleModuleVersion(d.getModuleVersion()));
                }
                dependencies.add(defaultDependency);
                continue;
            }
            if (!(dependency instanceof ModuleDependency)) continue;
            d = (ModuleDependency)dependency;
            DefaultIdeaModule targetModule = modules.get(d.getName());
            File targetProjectDirectory = targetModule == null ? this.compositeProjectMapper.transform(d.getGradlePath()) : targetModule.getGradleProject().getProjectDirectory();
            DefaultIdeaModuleDependency defaultDependency = new org.gradle.tooling.internal.idea.DefaultIdeaModuleDependency().setExported(d.isExported()).setScope(new DefaultIdeaDependencyScope(d.getScope())).setDependencyModule(targetModule).setProjectDirectory(targetProjectDirectory);
            dependencies.add(defaultDependency);
        }
        modules.get(ideaModule.getName()).setDependencies(dependencies);
    }

    private void appendModule(Map<String, DefaultIdeaModule> modules, IdeaModule ideaModule, DefaultIdeaProject ideaProject, DefaultGradleProject rootGradleProject) {
        DefaultIdeaContentRoot contentRoot = new DefaultIdeaContentRoot().setRootDirectory(ideaModule.getContentRoot()).setSourceDirectories(this.srcDirs(ideaModule.getSourceDirs(), ideaModule.getGeneratedSourceDirs())).setTestDirectories(this.srcDirs(ideaModule.getTestSourceDirs(), ideaModule.getGeneratedSourceDirs())).setExcludeDirectories(ideaModule.getExcludeDirs());
        Project project = ideaModule.getProject();
        DefaultIdeaModule defaultIdeaModule = new DefaultIdeaModule().setName(ideaModule.getName()).setParent(ideaProject).setGradleProject(rootGradleProject.findByPath(ideaModule.getProject().getPath())).setContentRoots(Collections.singletonList(contentRoot)).setCompilerOutput(new DefaultIdeaCompilerOutput().setInheritOutputDirs(ideaModule.getInheritOutputDirs() != null ? ideaModule.getInheritOutputDirs() : false).setOutputDir(ideaModule.getOutputDir()).setTestOutputDir(ideaModule.getTestOutputDir()));
        JavaPluginConvention javaPluginConvention = (JavaPluginConvention)project.getConvention().findPlugin(JavaPluginConvention.class);
        if (javaPluginConvention != null) {
            IdeaLanguageLevel ideaModuleLanguageLevel = ideaModule.getLanguageLevel();
            JavaVersion moduleSourceLanguageLevel = this.convertIdeaLanguageLevelToJavaVersion(ideaModuleLanguageLevel);
            JavaVersion moduleTargetBytecodeVersion = ideaModule.getTargetBytecodeVersion();
            defaultIdeaModule.setJavaLanguageSettings(new DefaultIdeaJavaLanguageSettings().setSourceLanguageLevel(moduleSourceLanguageLevel).setTargetBytecodeVersion(moduleTargetBytecodeVersion));
        }
        modules.put(ideaModule.getName(), defaultIdeaModule);
    }

    private Set<DefaultIdeaSourceDirectory> srcDirs(Set<File> sourceDirs, Set<File> generatedSourceDirs) {
        LinkedHashSet<DefaultIdeaSourceDirectory> out = new LinkedHashSet<DefaultIdeaSourceDirectory>();
        for (File s : sourceDirs) {
            DefaultIdeaSourceDirectory sourceDirectory = new DefaultIdeaSourceDirectory().setDirectory(s);
            if (generatedSourceDirs.contains(s)) {
                sourceDirectory.setGenerated(true);
            }
            out.add(sourceDirectory);
        }
        return out;
    }

    public IdeaModelBuilder setOfflineDependencyResolution(boolean offlineDependencyResolution) {
        this.offlineDependencyResolution = offlineDependencyResolution;
        return this;
    }

    private JavaVersion convertIdeaLanguageLevelToJavaVersion(IdeaLanguageLevel ideaLanguageLevel) {
        if (ideaLanguageLevel == null) {
            return null;
        }
        String languageLevel = ideaLanguageLevel.getLevel();
        return JavaVersion.valueOf((String)languageLevel.replaceFirst("JDK", "VERSION"));
    }
}

