/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class AbstractProgressLoggingHandler {
    protected final ProgressLoggerFactory progressLoggerFactory;

    public AbstractProgressLoggingHandler(ProgressLoggerFactory progressLoggerFactory) {
        this.progressLoggerFactory = progressLoggerFactory;
    }

    protected ResourceOperation createResourceOperation(String resourceName, ResourceOperation.Type operationType, Class loggingClazz, long contentLength) {
        ProgressLogger progressLogger = this.startProgress(operationType.getCapitalized() + " " + resourceName, loggingClazz);
        return new ResourceOperation(progressLogger, operationType, contentLength);
    }

    private ProgressLogger startProgress(String description, Class loggingClass) {
        ProgressLogger progressLogger = this.progressLoggerFactory.newOperation(loggingClass != null ? loggingClass : this.getClass());
        progressLogger.setDescription(description);
        progressLogger.setLoggingHeader(description);
        progressLogger.started();
        return progressLogger;
    }

    protected static class ProgressLoggingInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final ResourceOperation resourceOperation;

        public ProgressLoggingInputStream(InputStream inputStream, ResourceOperation resourceOperation) {
            this.inputStream = inputStream;
            this.resourceOperation = resourceOperation;
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        public int read() throws IOException {
            int result = this.inputStream.read();
            if (result >= 0) {
                this.doLogProgress(1L);
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.inputStream.read(b, off, len);
            if (read > 0) {
                this.doLogProgress(read);
            }
            return read;
        }

        private void doLogProgress(long numberOfBytes) {
            this.resourceOperation.logProcessedBytes(numberOfBytes);
        }
    }
}

