/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.ZInputStream;
import javajs.util.AU;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class FileReader {
    private final FileManager fm;
    private final Viewer vwr;
    private String fileNameIn;
    private String fullPathNameIn;
    private String nameAsGivenIn;
    private String fileTypeIn;
    private Object atomSetCollection;
    private Object reader;
    private Map<String, Object> htParams;
    private boolean isAppend;
    private byte[] bytes;

    public FileReader(FileManager fileManager, Viewer vwr, String fileName, String fullPathName, String nameAsGiven, String type, Object reader, Map<String, Object> htParams, boolean isAppend) {
        this.fm = fileManager;
        this.vwr = vwr;
        this.fileNameIn = fileName;
        this.fullPathNameIn = fullPathName;
        this.nameAsGivenIn = nameAsGiven;
        this.fileTypeIn = type;
        this.reader = reader instanceof BufferedReader ? reader : (reader instanceof Reader ? new BufferedReader((Reader)reader) : null);
        this.bytes = AU.isAB(reader) ? (byte[])reader : null;
        this.htParams = htParams;
        this.isAppend = isAppend;
    }

    public void run() {
        if (!this.isAppend && this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        String errorMessage = null;
        Object t = null;
        if (this.fullPathNameIn.contains("#_DOCACHE_")) {
            this.reader = FileReader.getChangeableReader(this.vwr, this.nameAsGivenIn, this.fullPathNameIn);
        }
        if (this.reader == null) {
            t = this.fm.getUnzippedReaderOrStreamFromName(this.fullPathNameIn, this.bytes, true, false, false, true, this.htParams);
            if (t == null || t instanceof String) {
                String string = errorMessage = t == null ? "error opening:" + this.nameAsGivenIn : (String)t;
                if (!errorMessage.startsWith("NOTE:")) {
                    Logger.error("file ERROR: " + this.fullPathNameIn + "\n" + errorMessage);
                }
                this.atomSetCollection = errorMessage;
                return;
            }
            if (t instanceof BufferedReader) {
                this.reader = t;
            } else if (t instanceof ZInputStream) {
                String name = this.fullPathNameIn;
                String[] subFileList = null;
                if ((name = name.replace('\\', '/')).indexOf("|") >= 0 && !name.endsWith(".zip")) {
                    subFileList = PT.split(name, "|");
                    name = subFileList[0];
                }
                if (subFileList != null) {
                    this.htParams.put("subFileList", subFileList);
                }
                InputStream zis = (InputStream)t;
                String[] zipDirectory = this.fm.getZipDirectory(name, true, true);
                this.atomSetCollection = t = this.fm.getJzu().getAtomSetCollectionOrBufferedReaderFromZip(this.vwr, zis, name, zipDirectory, this.htParams, 1, false);
                try {
                    zis.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (t instanceof BufferedInputStream) {
            GenericBinaryDocument bd = (GenericBinaryDocument)Interface.getInterface("javajs.util.BinaryDocument", this.vwr, "file");
            bd.setStream(this.vwr.getJzt(), (BufferedInputStream)t, true);
            this.reader = bd;
        }
        if (this.reader != null) {
            this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollectionReader(this.fullPathNameIn, this.fileTypeIn, this.reader, this.htParams);
            if (!(this.atomSetCollection instanceof String)) {
                this.atomSetCollection = this.vwr.getModelAdapter().getAtomSetCollection(this.atomSetCollection);
            }
            try {
                if (this.reader instanceof BufferedReader) {
                    ((BufferedReader)this.reader).close();
                } else if (this.reader instanceof GenericBinaryDocument) {
                    ((GenericBinaryDocument)this.reader).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.atomSetCollection instanceof String) {
            return;
        }
        if (!this.isAppend && !this.vwr.displayLoadErrors) {
            this.vwr.zap(false, true, false);
        }
        this.fm.setFileInfo(new String[]{this.fullPathNameIn, this.fileNameIn, this.nameAsGivenIn});
    }

    static final BufferedReader getChangeableReader(Viewer vwr, String nameAsGivenIn, String fullPathNameIn) {
        return Rdr.getBR((String)vwr.getLigandModel(nameAsGivenIn, fullPathNameIn, "_file", null));
    }

    public Object getAtomSetCollection() {
        return this.atomSetCollection;
    }
}

