/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.console;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import org.jmol.api.JmolAbstractButton;
import org.jmol.api.JmolAppConsoleInterface;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolScriptEditorInterface;
import org.jmol.c.CBK;
import org.jmol.console.GenericTextArea;
import org.jmol.i18n.GT;
import org.jmol.script.T;
import org.jmol.viewer.Viewer;

public abstract class GenericConsole
implements JmolAppConsoleInterface,
JmolCallbackListener {
    protected GenericTextArea input;
    protected GenericTextArea output;
    public Viewer vwr;
    protected static Map<String, String> labels;
    protected Map<String, Object> menuMap = new Hashtable<String, Object>();
    protected JmolAbstractButton editButton;
    protected JmolAbstractButton runButton;
    protected JmolAbstractButton historyButton;
    protected JmolAbstractButton stateButton;
    protected JmolAbstractButton clearOutButton;
    protected JmolAbstractButton clearInButton;
    protected JmolAbstractButton loadButton;
    protected String defaultMessage;
    protected JmolAbstractButton label1;
    public int nTab = 0;
    private String incompleteCmd;

    protected void setViewer(Viewer vwr) {
        this.vwr = vwr;
        if (labels == null) {
            Hashtable<String, String> l = new Hashtable<String, String>();
            l.put("title", GT._("Jmol Script Console") + " " + Viewer.getJmolVersion());
            this.setupLabels(l);
            labels = l;
        }
    }

    protected abstract boolean isMenuItem(Object var1);

    protected abstract void layoutWindow(String var1);

    protected abstract void setTitle();

    @Override
    public abstract void setVisible(boolean var1);

    @Override
    public abstract JmolScriptEditorInterface getScriptEditor();

    @Override
    public abstract void dispose();

    protected abstract JmolAbstractButton setButton(String var1);

    protected JmolAbstractButton addButton(JmolAbstractButton b, String label) {
        b.addConsoleListener(this);
        this.menuMap.put(label, b);
        return b;
    }

    protected JmolAbstractButton getLabel1() {
        return null;
    }

    protected void setupLabels(Map<String, String> labels) {
        labels.put("saveas", GT._("&Save As..."));
        labels.put("file", GT._("&File"));
        labels.put("close", GT._("&Close"));
        this.setupLabels0(labels);
    }

    protected void setupLabels0(Map<String, String> labels) {
        labels.put("help", GT._("&Help"));
        labels.put("search", GT._("&Search..."));
        labels.put("commands", GT._("&Commands"));
        labels.put("functions", GT._("Math &Functions"));
        labels.put("parameters", GT._("Set &Parameters"));
        labels.put("more", GT._("&More"));
        labels.put("Editor", GT._("Editor"));
        labels.put("State", GT._("State"));
        labels.put("Run", GT._("Run"));
        labels.put("Clear Output", GT._("Clear Output"));
        labels.put("Clear Input", GT._("Clear Input"));
        labels.put("History", GT._("History"));
        labels.put("Load", GT._("Load"));
        labels.put("label1", GT._("press CTRL-ENTER for new line or paste model data and press Load"));
        labels.put("default", GT._("Messages will appear here. Enter commands in the box below. Click the console Help menu item for on-line help, which will appear in a new browser window."));
    }

    protected void setLabels() {
        boolean doTranslate = GT.setDoTranslate(true);
        this.editButton = this.setButton("Editor");
        this.stateButton = this.setButton("State");
        this.runButton = this.setButton("Run");
        this.clearOutButton = this.setButton("Clear Output");
        this.clearInButton = this.setButton("Clear Input");
        this.historyButton = this.setButton("History");
        this.loadButton = this.setButton("Load");
        this.defaultMessage = GenericConsole.getLabel("default");
        this.setTitle();
        GT.setDoTranslate(doTranslate);
    }

    public static String getLabel(String key) {
        return labels.get(key);
    }

    protected void displayConsole() {
        this.layoutWindow(null);
        this.outputMsg(this.defaultMessage);
    }

    protected void updateLabels() {
    }

    protected abstract String nextFileName(String var1, int var2);

    public String completeCommand(String thisCmd) {
        String strCommand;
        if (thisCmd.length() == 0) {
            return null;
        }
        this.incompleteCmd = strCommand = this.nTab <= 0 || this.incompleteCmd == null ? thisCmd : this.incompleteCmd;
        String[] splitCmd = GenericConsole.splitCommandLine(thisCmd);
        if (splitCmd == null) {
            return null;
        }
        boolean asCommand = splitCmd[2] == null;
        boolean inBrace = splitCmd[3] != null;
        String notThis = splitCmd[asCommand ? 1 : 2];
        String s = splitCmd[1];
        if (notThis.length() == 0) {
            return null;
        }
        T token = T.getTokenFromName(s.trim().toLowerCase());
        int cmdtok = token == null ? 0 : token.tok;
        boolean isSelect = T.tokAttr(cmdtok, 12288);
        splitCmd = GenericConsole.splitCommandLine(strCommand);
        String cmd = null;
        if (!(asCommand || notThis.charAt(0) != '\"' && notThis.charAt(0) != '\'')) {
            char q = notThis.charAt(0);
            notThis = PT.trim(notThis, "\"'");
            String stub = PT.trim(splitCmd[2], "\"'");
            cmd = this.nextFileName(stub, this.nTab);
            if (cmd != null) {
                cmd = splitCmd[0] + splitCmd[1] + q + cmd + q;
            }
        } else {
            Hashtable map = null;
            if (!asCommand) {
                notThis = s;
                if (inBrace || splitCmd[2].startsWith("$") || isSelect) {
                    map = new Hashtable();
                    this.vwr.getObjectMap(map, (char)(inBrace || isSelect ? 123 : (splitCmd[2].startsWith("$") ? 36 : 48)));
                }
            }
            cmd = T.completeCommand(map, s.equalsIgnoreCase("set "), asCommand, asCommand ? splitCmd[1] : splitCmd[2], this.nTab);
            cmd = splitCmd[0] + (cmd == null ? notThis : (asCommand ? cmd : splitCmd[1] + cmd));
        }
        return cmd == null || cmd.equals(strCommand) ? null : cmd;
    }

    protected void doAction(Object source) {
        if (source == this.runButton) {
            this.execute(null);
        } else if (source == this.editButton) {
            this.vwr.getProperty("DATA_API", "scriptEditor", null);
        } else if (source == this.historyButton) {
            this.clearContent(this.vwr.getSetHistory(Integer.MAX_VALUE));
        } else if (source == this.stateButton) {
            this.clearContent(this.vwr.getStateInfo());
        } else if (source == this.clearInButton) {
            this.input.setText("");
            return;
        }
        if (source == this.clearOutButton) {
            this.output.setText("");
            return;
        }
        if (source == this.loadButton) {
            this.vwr.loadInlineAppend(this.input.getText(), false);
            return;
        }
        if (this.isMenuItem(source)) {
            this.execute(((JmolAbstractButton)source).getName());
            return;
        }
    }

    protected void execute(String strCommand) {
        String strErrorMessage;
        String cmd;
        String string = cmd = strCommand == null ? this.input.getText() : strCommand;
        if (strCommand == null) {
            this.input.setText(null);
        }
        if ((strErrorMessage = this.vwr.script(cmd + "\u0001## EDITOR_IGNORE ##")) != null && !strErrorMessage.equals("pending")) {
            this.outputMsg(strErrorMessage);
        }
    }

    protected void destroyConsole() {
        if (this.vwr.isApplet) {
            this.vwr.getProperty("DATA_API", "getAppConsole", Boolean.FALSE);
        }
    }

    public static void setAbstractButtonLabels(Map<String, Object> menuMap, Map<String, String> labels) {
        for (String key : menuMap.keySet()) {
            JmolAbstractButton m = (JmolAbstractButton)menuMap.get(key);
            String label = labels.get(key);
            if (key.indexOf("Tip") == key.length() - 3) {
                m.setToolTipText(labels.get(key));
                continue;
            }
            char mnemonic = GenericConsole.getMnemonic(label);
            if (mnemonic != ' ') {
                m.setMnemonic(mnemonic);
            }
            label = GenericConsole.getLabelWithoutMnemonic(label);
            m.setText(label);
        }
    }

    public static String getLabelWithoutMnemonic(String label) {
        if (label == null) {
            return null;
        }
        int index = label.indexOf(38);
        if (index == -1) {
            return label;
        }
        return label.substring(0, index) + (index < label.length() - 1 ? label.substring(index + 1) : "");
    }

    static char getMnemonic(String label) {
        if (label == null) {
            return ' ';
        }
        int index = label.indexOf(38);
        if (index == -1 || index == label.length() - 1) {
            return ' ';
        }
        return label.charAt(index + 1);
    }

    public static void map(Object button, String key, String label, Map<String, Object> menuMap) {
        char mnemonic = GenericConsole.getMnemonic(label);
        if (mnemonic != ' ') {
            ((JmolAbstractButton)button).setMnemonic(mnemonic);
        }
        if (menuMap != null) {
            menuMap.put(key, button);
        }
    }

    @Override
    public boolean notifyEnabled(CBK type) {
        switch (type) {
            case ECHO: 
            case MEASURE: 
            case MESSAGE: 
            case PICK: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void notifyCallback(CBK type, Object[] data) {
        String strInfo = data == null || data[1] == null ? null : data[1].toString();
        switch (type) {
            case ECHO: {
                this.sendConsoleEcho(strInfo);
                break;
            }
            case MEASURE: {
                String mystatus = (String)data[3];
                if (mystatus.indexOf("Picked") >= 0 || mystatus.indexOf("Sequence") >= 0) {
                    this.sendConsoleMessage(strInfo);
                    break;
                }
                if (mystatus.indexOf("Completed") < 0) break;
                this.sendConsoleEcho(strInfo.substring(strInfo.lastIndexOf(",") + 2, strInfo.length() - 1));
                break;
            }
            case MESSAGE: {
                this.sendConsoleMessage(data == null ? null : strInfo);
                break;
            }
            case PICK: {
                this.sendConsoleMessage(strInfo);
            }
        }
    }

    @Override
    public String getText() {
        return this.output.getText();
    }

    @Override
    public void sendConsoleEcho(String strEcho) {
        if (strEcho == null) {
            this.updateLabels();
            this.outputMsg(null);
            strEcho = this.defaultMessage;
        } else if (strEcho.equals("\u0000")) {
            strEcho = null;
        }
        this.outputMsg(strEcho);
    }

    private void outputMsg(String message) {
        int n = message == null ? -1 : message.length();
        switch (n) {
            case -1: {
                this.output.setText("");
                return;
            }
            default: {
                if (message.charAt(n - 1) == '\n') break;
            }
            case 0: {
                message = message + "\n";
            }
        }
        this.output.append(message);
    }

    protected void clearContent(String text) {
        this.output.setText(text);
    }

    @Override
    public void sendConsoleMessage(String strInfo) {
        if (strInfo != null && this.output.getText().startsWith(this.defaultMessage)) {
            this.outputMsg(null);
        }
        this.outputMsg(strInfo);
    }

    @Override
    public void setCallbackFunction(String callbackType, String callbackFunction) {
    }

    @Override
    public void zap() {
    }

    protected void recallCommand(boolean up) {
        String cmd = this.vwr.getSetHistory(up ? -1 : 1);
        if (cmd != null) {
            this.input.setText(PT.escUnicode(cmd));
        }
    }

    protected int processKey(int kcode, int kid, boolean isControlDown) {
        int mode = 0;
        switch (kid) {
            case 401: {
                switch (kcode) {
                    case 9: {
                        String s = this.input.getText();
                        if (s.endsWith("\n") || s.endsWith("\t")) {
                            return 0;
                        }
                        mode = 1;
                        if (this.input.getCaretPosition() != s.length()) break;
                        String cmd = this.completeCommand(s);
                        if (cmd != null) {
                            this.input.setText(PT.escUnicode(cmd).replace('\t', ' '));
                        }
                        ++this.nTab;
                        return mode;
                    }
                    case 27: {
                        mode = 1;
                        this.input.setText("");
                    }
                }
                this.nTab = 0;
                if (kcode == 10 && !isControlDown) {
                    this.execute(null);
                    return mode;
                }
                if (kcode != 38 && kcode != 40) break;
                this.recallCommand(kcode == 38);
                return mode;
            }
            case 402: {
                if (kcode != 10 || isControlDown) break;
                return mode;
            }
        }
        return mode | 2;
    }

    private static String[] splitCommandLine(String cmd) {
        String[] sout = new String[4];
        boolean isEscaped1 = false;
        boolean isEscaped2 = false;
        boolean isEscaped = false;
        if (cmd.length() == 0) {
            return null;
        }
        int ptQ = -1;
        int ptCmd = 0;
        int ptToken = 0;
        int nBrace = 0;
        block8: for (int i = 0; i < cmd.length(); ++i) {
            char ch = cmd.charAt(i);
            switch (ch) {
                case '\"': {
                    if (isEscaped || isEscaped1) break;
                    boolean bl = isEscaped2 = !isEscaped2;
                    if (!isEscaped2) break;
                    ptQ = ptToken = i;
                    break;
                }
                case '\'': {
                    if (isEscaped || isEscaped2) break;
                    boolean bl = isEscaped1 = !isEscaped1;
                    if (!isEscaped1) break;
                    ptQ = ptToken = i;
                    break;
                }
                case '\\': {
                    isEscaped = !isEscaped;
                    continue block8;
                }
                case ' ': {
                    if (isEscaped || isEscaped1 || isEscaped2) break;
                    ptToken = i + 1;
                    ptQ = -1;
                    break;
                }
                case ';': {
                    if (isEscaped1 || isEscaped2) break;
                    ptCmd = ptToken = i + 1;
                    ptQ = -1;
                    nBrace = 0;
                    break;
                }
                case '{': 
                case '}': {
                    if (isEscaped1 || isEscaped2) break;
                    nBrace += ch == '{' ? 1 : -1;
                    ptToken = i + 1;
                    ptQ = -1;
                    break;
                }
                default: {
                    if (isEscaped1 || isEscaped2) break;
                    ptQ = -1;
                }
            }
            isEscaped = false;
        }
        sout[0] = cmd.substring(0, ptCmd);
        sout[1] = ptToken == ptCmd ? cmd.substring(ptCmd) : cmd.substring(ptCmd, ptToken > ptQ ? ptToken : ptQ);
        sout[2] = ptToken == ptCmd ? null : cmd.substring(ptToken);
        sout[3] = nBrace > 0 ? "{" : null;
        return sout;
    }
}

