/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

class AboutDialog
extends JDialog
implements HyperlinkListener {
    protected JEditorPane html;
    protected URL aboutURL;
    private JmolViewer vwr;
    private JScrollPane scroller;

    AboutDialog(JFrame fr, JmolViewer vwr) {
        super(fr, GT._("About Jmol"), true);
        this.vwr = vwr;
        try {
            this.aboutURL = this.getClass().getClassLoader().getResource(JmolResourceHandler.getStringX("About.aboutURL"));
            if (this.aboutURL != null) {
                this.html = new JEditorPane();
                this.html.setContentType("text/html");
                this.html.setText(GuiMap.getResourceString(this, this.aboutURL.getPath()));
            } else {
                this.html = new JEditorPane("text/plain", GT.o(GT._("Unable to find url \"{0}\"."), JmolResourceHandler.getStringX("About.aboutURL")));
            }
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException e) {
            Logger.warn("Malformed URL: " + e);
        }
        catch (IOException e) {
            Logger.warn("IOException: " + e);
        }
        this.scroller = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.html);
        JPanel htmlWrapper = new JPanel(new BorderLayout());
        htmlWrapper.setAlignmentX(0.0f);
        htmlWrapper.add((Component)this.scroller, "Center");
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)htmlWrapper, "Center");
        this.getContentPane().add(container);
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL url) {
        this.vwr.showUrl(url.toString());
    }
}

