/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCacheEvent;
import org.openstreetmap.josm.data.osm.ChangesetCacheListener;
import org.openstreetmap.josm.data.osm.DefaultChangesetCacheEvent;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.Predicate;
import org.openstreetmap.josm.tools.Utils;

public final class ChangesetCache
implements Preferences.PreferenceChangedListener {
    private static final ChangesetCache instance = new ChangesetCache();
    private final Map<Integer, Changeset> cache = new HashMap<Integer, Changeset>();
    private final CopyOnWriteArrayList<ChangesetCacheListener> listeners = new CopyOnWriteArrayList();

    public static ChangesetCache getInstance() {
        return instance;
    }

    private ChangesetCache() {
        Main.pref.addPreferenceChangeListener(this);
    }

    public void addChangesetCacheListener(ChangesetCacheListener changesetCacheListener) {
        if (changesetCacheListener != null) {
            this.listeners.addIfAbsent(changesetCacheListener);
        }
    }

    public void removeChangesetCacheListener(ChangesetCacheListener changesetCacheListener) {
        if (changesetCacheListener != null) {
            this.listeners.remove(changesetCacheListener);
        }
    }

    protected void fireChangesetCacheEvent(final ChangesetCacheEvent changesetCacheEvent) {
        GuiHelper.runInEDT(new Runnable(){

            @Override
            public void run() {
                for (ChangesetCacheListener changesetCacheListener : ChangesetCache.this.listeners) {
                    changesetCacheListener.changesetCacheUpdated(changesetCacheEvent);
                }
            }
        });
    }

    protected void update(Changeset changeset, DefaultChangesetCacheEvent defaultChangesetCacheEvent) {
        if (changeset == null) {
            return;
        }
        if (changeset.isNew()) {
            return;
        }
        Changeset changeset2 = this.cache.get(changeset.getId());
        if (changeset2 != null) {
            changeset2.mergeFrom(changeset);
            defaultChangesetCacheEvent.rememberUpdatedChangeset(changeset2);
        } else {
            defaultChangesetCacheEvent.rememberAddedChangeset(changeset);
            this.cache.put(changeset.getId(), changeset);
        }
    }

    public void update(Changeset changeset) {
        DefaultChangesetCacheEvent defaultChangesetCacheEvent = new DefaultChangesetCacheEvent(this);
        this.update(changeset, defaultChangesetCacheEvent);
        this.fireChangesetCacheEvent(defaultChangesetCacheEvent);
    }

    public void update(Collection<Changeset> collection) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        DefaultChangesetCacheEvent defaultChangesetCacheEvent = new DefaultChangesetCacheEvent(this);
        for (Changeset changeset : collection) {
            this.update(changeset, defaultChangesetCacheEvent);
        }
        this.fireChangesetCacheEvent(defaultChangesetCacheEvent);
    }

    public boolean contains(int n) {
        if (n <= 0) {
            return false;
        }
        return this.cache.get(n) != null;
    }

    public boolean contains(Changeset changeset) {
        if (changeset == null) {
            return false;
        }
        if (changeset.isNew()) {
            return false;
        }
        return this.contains(changeset.getId());
    }

    public Changeset get(int n) {
        return this.cache.get(n);
    }

    public Set<Changeset> getChangesets() {
        return new HashSet<Changeset>(this.cache.values());
    }

    protected void remove(int n, DefaultChangesetCacheEvent defaultChangesetCacheEvent) {
        if (n <= 0) {
            return;
        }
        Changeset changeset = this.cache.get(n);
        if (changeset == null) {
            return;
        }
        this.cache.remove(n);
        defaultChangesetCacheEvent.rememberRemovedChangeset(changeset);
    }

    public void remove(int n) {
        DefaultChangesetCacheEvent defaultChangesetCacheEvent = new DefaultChangesetCacheEvent(this);
        this.remove(n, defaultChangesetCacheEvent);
        if (!defaultChangesetCacheEvent.isEmpty()) {
            this.fireChangesetCacheEvent(defaultChangesetCacheEvent);
        }
    }

    public void remove(Changeset changeset) {
        if (changeset == null) {
            return;
        }
        if (changeset.isNew()) {
            return;
        }
        this.remove(changeset.getId());
    }

    public void remove(Collection<Changeset> collection) {
        if (collection == null) {
            return;
        }
        DefaultChangesetCacheEvent defaultChangesetCacheEvent = new DefaultChangesetCacheEvent(this);
        for (Changeset changeset : collection) {
            if (changeset == null || changeset.isNew()) continue;
            this.remove(changeset.getId(), defaultChangesetCacheEvent);
        }
        if (!defaultChangesetCacheEvent.isEmpty()) {
            this.fireChangesetCacheEvent(defaultChangesetCacheEvent);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public void clear() {
        DefaultChangesetCacheEvent defaultChangesetCacheEvent = new DefaultChangesetCacheEvent(this);
        for (Changeset changeset : this.cache.values()) {
            defaultChangesetCacheEvent.rememberRemovedChangeset(changeset);
        }
        this.cache.clear();
        this.fireChangesetCacheEvent(defaultChangesetCacheEvent);
    }

    public List<Changeset> getOpenChangesets() {
        ArrayList<Changeset> arrayList = new ArrayList<Changeset>();
        for (Changeset changeset : this.cache.values()) {
            if (!changeset.isOpen()) continue;
            arrayList.add(changeset);
        }
        return arrayList;
    }

    public List<Changeset> getOpenChangesetsForCurrentUser() {
        if (JosmUserIdentityManager.getInstance().isAnonymous()) {
            return this.getOpenChangesets();
        }
        return new ArrayList<Changeset>(Utils.filter(this.getOpenChangesets(), new Predicate<Changeset>(){

            @Override
            public boolean evaluate(Changeset changeset) {
                return JosmUserIdentityManager.getInstance().isCurrentUser(changeset.getUser());
            }
        }));
    }

    @Override
    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey() == null || !"osm-server.url".equals(preferenceChangeEvent.getKey())) {
            return;
        }
        if (preferenceChangeEvent.getOldValue() == null || preferenceChangeEvent.getNewValue() == null || !preferenceChangeEvent.getOldValue().equals(preferenceChangeEvent.getNewValue())) {
            this.clear();
        }
    }
}

