/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class Tag
implements Tagged,
Map.Entry<String, String> {
    private final String key;
    private final String value;

    public Tag() {
        this("", "");
    }

    public Tag(String string) {
        this(string, "");
    }

    public Tag(String string, String string2) {
        this.key = string == null ? "" : string;
        this.value = string2 == null ? "" : string2;
    }

    public Tag(Tag tag) {
        this(tag.getKey(), tag.getValue());
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String string) {
        throw new UnsupportedOperationException();
    }

    public boolean matchesKey(String string) {
        return this.key.equals(string);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Tag tag = (Tag)object;
        return Objects.equals(this.key, tag.key) && Objects.equals(this.value, tag.value);
    }

    public static Tag ofString(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "s");
        String[] stringArray = string.split("=", 2);
        if (stringArray.length == 2) {
            return new Tag(stringArray[0], stringArray[1]);
        }
        throw new IllegalArgumentException('\'' + string + "' does not contain '='");
    }

    public String toString() {
        return this.key + '=' + this.value;
    }

    public static String removeWhiteSpaces(String string) {
        if (string == null || string.isEmpty()) {
            return string;
        }
        return Utils.strip(string).replaceAll("\\s+", " ");
    }

    @Override
    public void setKeys(Map<String, String> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, String> getKeys() {
        return Collections.singletonMap(this.key, this.value);
    }

    @Override
    public void put(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String get(String string) {
        return this.key.equals(string) ? this.value : null;
    }

    @Override
    public void remove(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasKeys() {
        return true;
    }

    @Override
    public Collection<String> keySet() {
        return Collections.singleton(this.key);
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException();
    }
}

