/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MapMover
extends MouseAdapter
implements Destroyable {
    public static final BooleanProperty PROP_ZOOM_REVERSE_WHEEL = new BooleanProperty("zoom.reverse-wheel", false);
    private static final JMapViewerUpdater jMapViewerUpdater = new JMapViewerUpdater();
    private EastNorth mousePosMove;
    private final NavigatableComponent nc;
    private final JPanel contentPane;
    private boolean movementInPlace;

    public MapMover(NavigatableComponent navigatableComponent, JPanel jPanel) {
        this.nc = navigatableComponent;
        this.contentPane = jPanel;
        this.nc.addMouseListener(this);
        this.nc.addMouseMotionListener(this);
        this.nc.addMouseWheelListener(this);
        if (jPanel != null) {
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusright", I18n.tr("Map: {0}", I18n.tr("Move right", new Object[0])), 39, 5006).getKeyStroke(), "MapMover.Zoomer.right");
            jPanel.getActionMap().put("MapMover.Zoomer.right", new ZoomerAction("right"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusleft", I18n.tr("Map: {0}", I18n.tr("Move left", new Object[0])), 37, 5006).getKeyStroke(), "MapMover.Zoomer.left");
            jPanel.getActionMap().put("MapMover.Zoomer.left", new ZoomerAction("left"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusup", I18n.tr("Map: {0}", I18n.tr("Move up", new Object[0])), 38, 5006).getKeyStroke(), "MapMover.Zoomer.up");
            jPanel.getActionMap().put("MapMover.Zoomer.up", new ZoomerAction("up"));
            jPanel.getInputMap(2).put(Shortcut.registerShortcut("system:movefocusdown", I18n.tr("Map: {0}", I18n.tr("Move down", new Object[0])), 40, 5006).getKeyStroke(), "MapMover.Zoomer.down");
            jPanel.getActionMap().put("MapMover.Zoomer.down", new ZoomerAction("down"));
            if (!Main.isPlatformOsx()) {
                jPanel.getInputMap(2).put(Shortcut.registerShortcut("view:zoominalternate", I18n.tr("Map: {0}", I18n.tr("Zoom in", new Object[0])), 44, 5006).getKeyStroke(), "MapMover.Zoomer.in");
                jPanel.getActionMap().put("MapMover.Zoomer.in", new ZoomerAction(","));
                jPanel.getInputMap(2).put(Shortcut.registerShortcut("view:zoomoutalternate", I18n.tr("Map: {0}", I18n.tr("Zoom out", new Object[0])), 46, 5006).getKeyStroke(), "MapMover.Zoomer.out");
                jPanel.getActionMap().put("MapMover.Zoomer.out", new ZoomerAction("."));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl;
        int n = 3072;
        int n2 = 1152;
        boolean bl2 = (mouseEvent.getModifiersEx() & (0x1000 | n)) == 4096;
        boolean bl3 = Main.isPlatformOsx() && mouseEvent.getModifiersEx() == n2;
        boolean bl4 = bl = !Main.map.mapModeSelect.equals(Main.map.mapMode) || SelectAction.Mode.SELECT.equals((Object)Main.map.mapModeSelect.getMode());
        if (bl2 || bl3 && bl) {
            if (this.mousePosMove == null) {
                this.startMovement(mouseEvent);
            }
            EastNorth eastNorth = this.nc.getCenter();
            EastNorth eastNorth2 = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
            this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + eastNorth.east() - eastNorth2.east(), this.mousePosMove.north() + eastNorth.north() - eastNorth2.north()));
        } else {
            this.endMovement();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n = 3072;
        int n2 = 1152;
        if (mouseEvent.getButton() == 3 && (mouseEvent.getModifiersEx() & n) == 0 || Main.isPlatformOsx() && mouseEvent.getModifiersEx() == n2) {
            this.startMovement(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3 || Main.isPlatformOsx() && mouseEvent.getButton() == 1) {
            this.endMovement();
        }
    }

    private void startMovement(MouseEvent mouseEvent) {
        if (this.movementInPlace) {
            return;
        }
        this.movementInPlace = true;
        this.mousePosMove = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        this.nc.setNewCursor(13, (Object)this);
    }

    private void endMovement() {
        if (!this.movementInPlace) {
            return;
        }
        this.movementInPlace = false;
        this.nc.resetCursor(this);
        this.mousePosMove = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = PROP_ZOOM_REVERSE_WHEEL.get() != false ? -mouseWheelEvent.getWheelRotation() : mouseWheelEvent.getWheelRotation();
        this.nc.zoomManyTimes(mouseWheelEvent.getX(), mouseWheelEvent.getY(), n);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.movementInPlace) {
            return;
        }
        if (Main.isPlatformOsx()) {
            if (mouseEvent.getModifiersEx() == 128) {
                if (this.mousePosMove == null) {
                    this.startMovement(mouseEvent);
                }
                EastNorth eastNorth = this.nc.getCenter();
                EastNorth eastNorth2 = this.nc.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
                this.nc.zoomTo(new EastNorth(this.mousePosMove.east() + eastNorth.east() - eastNorth2.east(), this.mousePosMove.north() + eastNorth.north() - eastNorth2.north()));
            } else {
                this.endMovement();
            }
        }
    }

    @Override
    public void destroy() {
        if (this.contentPane != null) {
            Object[] objectArray;
            Object object;
            InputMap inputMap = this.contentPane.getInputMap();
            KeyStroke[] keyStrokeArray = inputMap.keys();
            if (keyStrokeArray != null) {
                object = keyStrokeArray;
                int n = ((KeyStroke[])object).length;
                for (int i = 0; i < n; ++i) {
                    Object object2 = object[i];
                    Object object3 = inputMap.get((KeyStroke)object2);
                    if (!(object3 instanceof String) || !((String)object3).startsWith("MapMover.")) continue;
                    inputMap.remove((KeyStroke)object2);
                }
            }
            if ((objectArray = ((ActionMap)(object = this.contentPane.getActionMap())).keys()) != null) {
                for (Object object4 : objectArray) {
                    if (!(object4 instanceof String) || !((String)object4).startsWith("MapMover.")) continue;
                    ((ActionMap)object).remove(object4);
                }
            }
        }
    }

    private final class ZoomerAction
    extends AbstractAction {
        private final String action;

        ZoomerAction(String string) {
            this.action = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (".".equals(this.action) || ",".equals(this.action)) {
                Point point = MapMover.this.nc.getMousePosition();
                if (point == null) {
                    point = new Point((int)MapMover.this.nc.getBounds().getCenterX(), (int)MapMover.this.nc.getBounds().getCenterY());
                }
                MouseWheelEvent mouseWheelEvent = new MouseWheelEvent((Component)MapMover.this.nc, actionEvent.getID(), actionEvent.getWhen(), actionEvent.getModifiers(), point.x, point.y, 0, false, 0, 1, ",".equals(this.action) ? -1 : 1);
                MapMover.this.mouseWheelMoved(mouseWheelEvent);
            } else {
                EastNorth eastNorth = MapMover.this.nc.getCenter();
                EastNorth eastNorth2 = MapMover.this.nc.getEastNorth(MapMover.this.nc.getWidth() / 2 + MapMover.this.nc.getWidth() / 5, MapMover.this.nc.getHeight() / 2 + MapMover.this.nc.getHeight() / 5);
                switch (this.action) {
                    case "left": {
                        MapMover.this.nc.zoomTo(new EastNorth(2.0 * eastNorth.east() - eastNorth2.east(), eastNorth.north()));
                        break;
                    }
                    case "right": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth2.east(), eastNorth.north()));
                        break;
                    }
                    case "up": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), 2.0 * eastNorth.north() - eastNorth2.north()));
                        break;
                    }
                    case "down": {
                        MapMover.this.nc.zoomTo(new EastNorth(eastNorth.east(), eastNorth2.north()));
                        break;
                    }
                }
            }
        }
    }

    private static class JMapViewerUpdater
    implements Preferences.PreferenceChangedListener {
        JMapViewerUpdater() {
            Main.pref.addPreferenceChangeListener(this);
            JMapViewerUpdater.updateJMapViewer();
        }

        @Override
        public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
            if (PROP_ZOOM_REVERSE_WHEEL.getKey().equals(preferenceChangeEvent.getKey())) {
                JMapViewerUpdater.updateJMapViewer();
            }
        }

        private static void updateJMapViewer() {
            JMapViewer.zoomReverseWheel = PROP_ZOOM_REVERSE_WHEEL.get();
        }
    }
}

