/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.exception.OAuthException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.data.oauth.OsmPrivileges;
import org.openstreetmap.josm.gui.oauth.OsmLoginFailedException;
import org.openstreetmap.josm.gui.oauth.OsmOAuthAuthorizationException;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OsmOAuthAuthorizationClient {
    private final OAuthParameters oauthProviderParameters;
    private final OAuthConsumer consumer;
    private final OAuthProvider provider;
    private boolean canceled;
    private HttpClient connection;

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OsmOAuthAuthorizationClient(OAuthParameters oAuthParameters, OAuthToken oAuthToken) {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        this.oauthProviderParameters = new OAuthParameters(oAuthParameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(oAuthToken.getKey(), oAuthToken.getSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object;
        this.canceled = true;
        if (this.provider != null) {
            try {
                object = this.provider.getClass().getDeclaredField("connection");
                Utils.setObjectsAccessible(new AccessibleObject[]{object});
                HttpURLConnection httpURLConnection = (HttpURLConnection)((Field)object).get(this.provider);
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                Main.error(exception);
                Main.warn(I18n.tr("Failed to cancel running OAuth operation", new Object[0]));
            }
        }
        object = this;
        synchronized (object) {
            if (this.connection != null) {
                this.connection.disconnect();
            }
        }
    }

    public OAuthToken getRequestToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Request Token from ''{0}''", this.oauthProviderParameters.getRequestTokenUrl()));
            this.provider.retrieveRequestToken(this.consumer, "", new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(oAuthException);
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public OAuthToken getAccessToken(ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask("");
            progressMonitor.indeterminateSubTask(I18n.tr("Retrieving OAuth Access Token from ''{0}''", this.oauthProviderParameters.getAccessTokenUrl()));
            this.provider.retrieveAccessToken(this.consumer, null, new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (OAuthException oAuthException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(oAuthException);
            }
            throw new OsmOAuthAuthorizationException(oAuthException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public String getAuthoriseUrl(OAuthToken oAuthToken) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?oauth_token=").append(oAuthToken.getKey());
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractToken() {
        try (BufferedReader bufferedReader = this.connection.getResponse().getContentReader();){
            String string;
            Pattern pattern = Pattern.compile(".*authenticity_token.*value=\"([^\"]+)\".*");
            while ((string = bufferedReader.readLine()) != null) {
                Matcher matcher = pattern.matcher(string);
                if (!matcher.find()) continue;
                String string2 = matcher.group(1);
                return string2;
            }
        }
        catch (IOException iOException) {
            Main.error(iOException);
            return null;
        }
        Main.warn("No authenticity_token found in response!");
        return null;
    }

    protected SessionId extractOsmSession() throws IOException, URISyntaxException {
        List<String> list = CookieHandler.getDefault().get(this.connection.getURL().toURI(), Collections.emptyMap()).get("Cookie");
        if (list == null) {
            Main.warn("No 'Set-Cookie' in response header!");
            return null;
        }
        for (String string : list) {
            String[] stringArray = string.split(";");
            if (stringArray == null || stringArray.length == 0) continue;
            for (String string2 : stringArray) {
                String[] stringArray2 = (string2 = string2.trim()).split("=");
                if (stringArray2 == null || stringArray2.length != 2 || !"_osm_session".equals(stringArray2[0])) continue;
                String string3 = this.extractToken();
                if (string3 == null) {
                    return null;
                }
                SessionId sessionId = new SessionId();
                sessionId.id = stringArray2[1];
                sessionId.token = string3;
                return sessionId;
            }
        }
        Main.warn("No suitable 'Set-Cookie' in response header found! {0}", list);
        return null;
    }

    protected static String buildPostRequest(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder(32);
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String string = entry.getValue();
            string = string == null ? "" : string;
            stringBuilder.append(entry.getKey()).append('=').append(Utils.encodeUrl(string));
            if (!iterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionId fetchOsmWebsiteSessionId() throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getOsmLoginUrl() + "?cookie_test=true");
            Object object = this;
            synchronized (object) {
                this.connection = HttpClient.create(uRL).useCache(false);
                this.connection.connect();
            }
            object = this.extractOsmSession();
            if (object == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", uRL.toString()));
            }
            Object object2 = object;
            return object2;
        }
        catch (IOException | URISyntaxException exception) {
            throw new OsmOAuthAuthorizationException(exception);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchOAuthToken(SessionId sessionId, OAuthToken oAuthToken) throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.getAuthoriseUrl(oAuthToken));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = HttpClient.create(uRL).useCache(false).setHeader("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
                this.connection.connect();
            }
            sessionId.token = this.extractToken();
            if (sessionId.token == null) {
                throw new OsmOAuthAuthorizationException(I18n.tr("OSM website did not return a session cookie in response to ''{0}'',", uRL.toString()));
            }
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticateOsmSession(SessionId sessionId, String string, String string2) throws OsmLoginFailedException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getOsmLoginUrl());
            HttpClient httpClient = HttpClient.create(uRL, "POST").useCache(false);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("username", string);
            hashMap.put("password", string2);
            hashMap.put("referer", "/");
            hashMap.put("commit", "Login");
            hashMap.put("authenticity_token", sessionId.token);
            httpClient.setRequestBody(OsmOAuthAuthorizationClient.buildPostRequest(hashMap).getBytes(StandardCharsets.UTF_8));
            httpClient.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpClient.setHeader("Cookie", "_osm_session=" + sessionId.id);
            httpClient.setMaxRedirects(-1);
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = httpClient;
                this.connection.connect();
            }
            int n = this.connection.getResponse().getResponseCode();
            if (n != 302) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", string));
            }
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            throw new OsmLoginFailedException(osmOAuthAuthorizationException.getCause());
        }
        catch (IOException iOException) {
            throw new OsmLoginFailedException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logoutOsmSession(SessionId sessionId) throws OsmOAuthAuthorizationException {
        try {
            URL uRL = new URL(this.oauthProviderParameters.getOsmLogoutUrl());
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = HttpClient.create(uRL).setMaxRedirects(-1);
                this.connection.connect();
            }
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAuthorisationRequest(SessionId sessionId, OAuthToken oAuthToken, OsmPrivileges osmPrivileges) throws OsmOAuthAuthorizationException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.fetchOAuthToken(sessionId, oAuthToken);
        hashMap.put("oauth_token", oAuthToken.getKey());
        hashMap.put("oauth_callback", "");
        hashMap.put("authenticity_token", sessionId.token);
        if (osmPrivileges.isAllowWriteApi()) {
            hashMap.put("allow_write_api", "yes");
        }
        if (osmPrivileges.isAllowWriteGpx()) {
            hashMap.put("allow_write_gpx", "yes");
        }
        if (osmPrivileges.isAllowReadGpx()) {
            hashMap.put("allow_read_gpx", "yes");
        }
        if (osmPrivileges.isAllowWritePrefs()) {
            hashMap.put("allow_write_prefs", "yes");
        }
        if (osmPrivileges.isAllowReadPrefs()) {
            hashMap.put("allow_read_prefs", "yes");
        }
        if (osmPrivileges.isAllowModifyNotes()) {
            hashMap.put("allow_write_notes", "yes");
        }
        hashMap.put("commit", "Save changes");
        String string = OsmOAuthAuthorizationClient.buildPostRequest(hashMap);
        try {
            URL uRL = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            HttpClient httpClient = HttpClient.create(uRL, "POST").useCache(false);
            httpClient.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpClient.setHeader("Cookie", "_osm_session=" + sessionId.id + "; _osm_username=" + sessionId.userName);
            httpClient.setMaxRedirects(-1);
            httpClient.setRequestBody(string.getBytes(StandardCharsets.UTF_8));
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = httpClient;
                this.connection.connect();
            }
            int n = this.connection.getResponse().getResponseCode();
            if (n != 200) {
                throw new OsmOAuthAuthorizationException(I18n.tr("Failed to authorize OAuth request  ''{0}''", oAuthToken.getKey()));
            }
        }
        catch (IOException iOException) {
            throw new OsmOAuthAuthorizationException(iOException);
        }
        finally {
            OsmOAuthAuthorizationClient osmOAuthAuthorizationClient = this;
            synchronized (osmOAuthAuthorizationClient) {
                this.connection = null;
            }
        }
    }

    public void authorise(OAuthToken oAuthToken, String string, String string2, OsmPrivileges osmPrivileges, ProgressMonitor progressMonitor) throws OsmOAuthAuthorizationException, OsmTransferCanceledException {
        CheckParameterUtil.ensureParameterNotNull(oAuthToken, "requestToken");
        CheckParameterUtil.ensureParameterNotNull(string, "userName");
        CheckParameterUtil.ensureParameterNotNull(string2, "password");
        CheckParameterUtil.ensureParameterNotNull(osmPrivileges, "privileges");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            progressMonitor.beginTask(I18n.tr("Authorizing OAuth Request token ''{0}'' at the OSM website ...", oAuthToken.getKey()));
            progressMonitor.setTicksCount(4);
            progressMonitor.indeterminateSubTask(I18n.tr("Initializing a session at the OSM website...", new Object[0]));
            SessionId sessionId = this.fetchOsmWebsiteSessionId();
            sessionId.userName = string;
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authenticating the session for user ''{0}''...", string));
            this.authenticateOsmSession(sessionId, string, string2);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Authorizing request token ''{0}''...", oAuthToken.getKey()));
            this.sendAuthorisationRequest(sessionId, oAuthToken, osmPrivileges);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            progressMonitor.worked(1);
            progressMonitor.indeterminateSubTask(I18n.tr("Logging out session ''{0}''...", sessionId));
            this.logoutOsmSession(sessionId);
            if (this.canceled) {
                throw new OsmTransferCanceledException("Authorization canceled");
            }
            progressMonitor.worked(1);
        }
        catch (OsmOAuthAuthorizationException osmOAuthAuthorizationException) {
            if (this.canceled) {
                throw new OsmTransferCanceledException(osmOAuthAuthorizationException);
            }
            throw osmOAuthAuthorizationException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private static class SessionId {
        private String id;
        private String token;
        private String userName;

        private SessionId() {
        }
    }
}

