/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.module;

import java.math.BigDecimal;
import java.util.Objects;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.module.TaskExecutionRequestEvent;
import org.pdfsam.ui.module.OpenButton;
import org.pdfsam.ui.module.RunButton;
import org.pdfsam.ui.module.TaskFailedButton;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.model.exception.TaskOutputVisitException;
import org.sejda.model.notification.event.PercentageOfWorkDoneChangedEvent;
import org.sejda.model.notification.event.TaskExecutionCompletedEvent;
import org.sejda.model.notification.event.TaskExecutionFailedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Footer
extends HBox {
    private static final Logger LOG = LoggerFactory.getLogger(Footer.class);
    private ProgressBar bar = new ProgressBar(0.0);
    private Label statusLabel = new Label();
    private OpenButton open = new OpenButton();
    private TaskFailedButton failed = new TaskFailedButton();

    public Footer(RunButton runButton) {
        this.getStyleClass().addAll((Object[])new String[]{"pdfsam-container", "footer-pane"});
        this.statusLabel.getStyleClass().add((Object)"status-label");
        this.statusLabel.setVisible(false);
        this.bar.setMaxWidth(Double.MAX_VALUE);
        this.bar.getStyleClass().add((Object)"pdfsam-footer-bar");
        this.statusLabel.setMaxHeight(Double.MAX_VALUE);
        VBox progressPane = new VBox(new Node[]{this.statusLabel, this.bar});
        progressPane.getStyleClass().add((Object)"progress-pane");
        VBox.setVgrow((Node)this.statusLabel, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.bar, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)progressPane, (Priority)Priority.ALWAYS);
        this.failed.setVisible(false);
        this.open.setVisible(false);
        StackPane buttons = new StackPane(new Node[]{this.failed, this.open});
        buttons.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().addAll((Object[])new Node[]{runButton, buttons, progressPane});
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void onTaskExecutionRequest(TaskExecutionRequestEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(false);
        this.statusLabel.setVisible(true);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Requested"));
        this.bar.setProgress(0.0);
        try {
            if (!Objects.isNull(event.getParameters().getOutput())) {
                event.getParameters().getOutput().accept(this.open);
            }
        }
        catch (TaskOutputVisitException e) {
            LOG.warn("This should never happen", e);
        }
    }

    @EventListener
    public void onTaskCompleted(TaskExecutionCompletedEvent event) {
        this.open.setVisible(true);
        this.failed.setVisible(false);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Completed"));
        this.bar.setProgress(1.0);
    }

    @EventListener
    public void onTaskFailed(TaskExecutionFailedEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(true);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Failed"));
    }

    @EventListener
    public void onProgress(PercentageOfWorkDoneChangedEvent event) {
        this.open.setVisible(false);
        this.failed.setVisible(false);
        this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running"));
        if (event.isUndetermined()) {
            this.bar.setProgress(-1.0);
        } else {
            this.bar.setProgress(event.getPercentage().divide(new BigDecimal(100)).doubleValue());
            this.statusLabel.setText(DefaultI18nContext.getInstance().i18n("Running {0}%", Integer.toString(event.getPercentage().intValue())));
        }
    }
}

