/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.conversion;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.sejda.conversion.CsvFileSourceListParser;
import org.sejda.conversion.FolderFileSourceListParser;
import org.sejda.conversion.PdfInputFilesSource;
import org.sejda.conversion.XmlFileSourceListParser;
import org.sejda.conversion.exception.ConversionException;
import org.sejda.model.exception.SejdaRuntimeException;
import org.sejda.model.input.PdfFileSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfFileSourceListAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(PdfFileSourceListAdapter.class);
    private final PdfInputFilesSourceFactory parserFactory = new PdfInputFilesSourceFactory();
    private final List<PdfFileSource> fileSourceList = new ArrayList<PdfFileSource>();
    private final File file;
    private Pattern pattern = Pattern.compile(".+");

    public PdfFileSourceListAdapter(String filePath) {
        this.file = new File(filePath);
        if (!this.file.exists()) {
            throw new ConversionException("File '" + this.file.getPath() + "' does not exist");
        }
    }

    public PdfFileSourceListAdapter filter(String filterRegExp) {
        if (StringUtils.isNotBlank(filterRegExp)) {
            LOG.debug("Applying regular expression: {}", (Object)filterRegExp);
            this.pattern = Pattern.compile(filterRegExp);
        }
        return this;
    }

    public List<PdfFileSource> getFileSourceList() {
        this.fileSourceList.addAll(this.parserFactory.createSource(this.file).getInputFiles(this.file));
        if (this.fileSourceList.isEmpty()) {
            throw new ConversionException("No input files specified in '" + this.file.getPath() + "'");
        }
        return this.fileSourceList;
    }

    class PdfInputFilesSourceFactory {
        private static final String XML_EXTENSION = "xml";
        private static final String CSV_EXTENSION = "csv";

        PdfInputFilesSourceFactory() {
        }

        PdfInputFilesSource createSource(File file) {
            String extension = FilenameUtils.getExtension(file.getName());
            if (file.isDirectory()) {
                return new FolderFileSourceListParser(PdfFileSourceListAdapter.this.pattern);
            }
            if (CSV_EXTENSION.equalsIgnoreCase(extension)) {
                return new CsvFileSourceListParser();
            }
            if (XML_EXTENSION.equalsIgnoreCase(extension)) {
                return new XmlFileSourceListParser();
            }
            throw new SejdaRuntimeException("Cannot read input file names from config file '" + file.getName() + "'. Unsupported file format: " + extension);
        }
    }
}

