/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import java.io.File;
import java.util.Set;
import org.sejda.common.ComponentsUtility;
import org.sejda.core.notification.dsl.ApplicationEventsNotifier;
import org.sejda.core.support.io.IOUtils;
import org.sejda.core.support.io.MultipleOutputWriter;
import org.sejda.core.support.io.OutputWriters;
import org.sejda.core.support.io.model.FileOutput;
import org.sejda.core.support.prefix.NameGenerator;
import org.sejda.core.support.prefix.model.NameGenerationRequest;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PdfTextExtractor;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.ExtractTextByPagesParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractTextByPagesTask
extends BaseTask<ExtractTextByPagesParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(ExtractTextByPagesTask.class);
    private PDDocumentHandler documentHandler = null;
    private MultipleOutputWriter outputWriter;
    private PdfSourceOpener<PDDocumentHandler> documentLoader;

    @Override
    public void before(ExtractTextByPagesParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
        this.outputWriter = OutputWriters.newMultipleOutputWriter(parameters.getExistingOutputPolicy());
    }

    @Override
    public void execute(ExtractTextByPagesParameters parameters) throws TaskException {
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.documentHandler = source.open(this.documentLoader);
        this.documentHandler.getPermissions().ensurePermission(PdfAccessPermission.COPY_AND_EXTRACT);
        this.documentHandler.setCompress(parameters.isCompress());
        this.documentHandler.setVersionOnPDDocument(parameters.getVersion());
        Set<Integer> pages = parameters.getPages(this.documentHandler.getNumberOfPages());
        if (pages == null || pages.isEmpty()) {
            throw new TaskExecutionException("No page has been selected for extraction.");
        }
        int currentStep = 0;
        int totalSteps = pages.size();
        for (Integer current : pages) {
            this.stopTaskIfCancelled();
            ++currentStep;
            LOG.debug("Extracting text from page {}", (Object)current);
            File tmpFile = IOUtils.createTemporaryBuffer();
            LOG.debug("Created output on temporary buffer {}", (Object)tmpFile);
            PdfTextExtractor textExtractor = new PdfTextExtractor(parameters.getTextEncoding(), current, current);
            textExtractor.extract(this.documentHandler.getUnderlyingPDDocument(), tmpFile);
            String outName = NameGenerator.nameGenerator(parameters.getOutputPrefix()).generate(NameGenerationRequest.nameRequest("txt").page(current).originalName(parameters.getSource().getName()).fileNumber(currentStep));
            this.outputWriter.addOutput(FileOutput.file(tmpFile).name(outName));
            ComponentsUtility.nullSafeCloseQuietly(textExtractor);
            ApplicationEventsNotifier.notifyEvent(this.getNotifiableTaskMetadata()).stepsCompleted(currentStep).outOf(totalSteps);
        }
        parameters.getOutput().accept(this.outputWriter);
        LOG.debug("Text extracted from input documents and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.documentHandler);
    }
}

