/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox;

import org.sejda.common.ComponentsUtility;
import org.sejda.impl.sambox.component.DefaultPdfSourceOpener;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.optimizaton.OptimizationRuler;
import org.sejda.impl.sambox.component.split.AbstractPdfSplitter;
import org.sejda.impl.sambox.component.split.ByTextChangesPdfSplitter;
import org.sejda.model.exception.TaskException;
import org.sejda.model.input.PdfSource;
import org.sejda.model.input.PdfSourceOpener;
import org.sejda.model.parameter.SplitByTextContentParameters;
import org.sejda.model.pdf.encryption.PdfAccessPermission;
import org.sejda.model.task.BaseTask;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitByTextContentTask
extends BaseTask<SplitByTextContentParameters> {
    private static final Logger LOG = LoggerFactory.getLogger(SplitByTextContentTask.class);
    private PdfSourceOpener<PDDocumentHandler> documentLoader;
    private PDDocumentHandler sourceDocumentHandler;
    private AbstractPdfSplitter<SplitByTextContentParameters> splitter;

    @Override
    public void before(SplitByTextContentParameters parameters) {
        this.documentLoader = new DefaultPdfSourceOpener();
    }

    @Override
    public void execute(SplitByTextContentParameters parameters) throws TaskException {
        PdfSource source = parameters.getSource();
        LOG.debug("Opening {}", (Object)source);
        this.sourceDocumentHandler = source.open(this.documentLoader);
        this.sourceDocumentHandler.getPermissions().ensurePermission(PdfAccessPermission.ASSEMBLE);
        PDDocument sourceDocument = this.sourceDocumentHandler.getUnderlyingPDDocument();
        this.splitter = new ByTextChangesPdfSplitter(sourceDocument, parameters, new OptimizationRuler(parameters.getOptimizationPolicy()).apply(sourceDocument));
        LOG.debug("Starting to split by text content");
        this.splitter.split(this.getNotifiableTaskMetadata());
        LOG.debug("Input documents split and written to {}", (Object)parameters.getOutput());
    }

    @Override
    public void after() {
        this.closeResource();
    }

    private void closeResource() {
        ComponentsUtility.nullSafeCloseQuietly(this.sourceDocumentHandler);
        this.splitter = null;
    }
}

