/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.sejda.impl.sambox.component.ReadOnlyFilteredCOSStream;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.MissingOperandException;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.MissingResourceException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.graphics.PDXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDFormXObject;
import org.sejda.sambox.pdmodel.graphics.form.PDTransparencyGroup;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesHitter
extends PDFStreamEngine
implements Consumer<PDPage> {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesHitter.class);

    public ImagesHitter() {
        this.addOperator(new XObjectOperator());
    }

    @Override
    public void accept(PDPage page) {
        try {
            this.processPage(page);
            for (PDAnnotation annotation : page.getAnnotations()) {
                this.showAnnotation(annotation);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed parse page, skipping and continuing with next.", e);
        }
    }

    private class XObjectOperator
    extends OperatorProcessor {
        private XObjectOperator() {
        }

        @Override
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.size() < 1) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase operand = operands.get(0);
            if (operand instanceof COSName) {
                COSName objectName = (COSName)operand;
                Optional<COSDictionary> xobjects = Optional.ofNullable(this.context.getResources().getCOSObject().getDictionaryObject(COSName.XOBJECT)).filter(d -> d instanceof COSDictionary).map(d -> (COSDictionary)d);
                COSBase existing = xobjects.map(d -> d.getDictionaryObject(objectName)).orElseThrow(() -> new MissingResourceException("Missing XObject: " + objectName.getName()));
                if (!(existing instanceof ReadOnlyFilteredCOSStream)) {
                    COSStream imageStream = Optional.ofNullable(existing).filter(e -> e instanceof COSStream).map(e -> (COSStream)e).orElseThrow(() -> new IllegalArgumentException("External object unexpected type"));
                    String subtype = imageStream.getNameAsString(COSName.SUBTYPE);
                    if (COSName.IMAGE.getName().equals(subtype)) {
                        LOG.trace("Hit image with name {}", (Object)objectName.getName());
                        ReadOnlyFilteredCOSStream optimizedImage = ReadOnlyFilteredCOSStream.readOnly(imageStream);
                        COSDictionary resources = this.context.getResources().getCOSObject();
                        xobjects.orElseGet(() -> {
                            COSDictionary ret = new COSDictionary();
                            resources.setItem(COSName.XOBJECT, (COSBase)ret);
                            return ret;
                        }).setItem(objectName, (COSBase)optimizedImage);
                    } else if (COSName.FORM.getName().equals(subtype)) {
                        PDXObject xobject = PDXObject.createXObject(imageStream, this.context.getResources());
                        if (xobject instanceof PDTransparencyGroup) {
                            this.context.showTransparencyGroup((PDTransparencyGroup)xobject);
                        } else if (xobject instanceof PDFormXObject) {
                            this.context.showForm((PDFormXObject)xobject);
                        }
                    }
                }
            }
        }

        @Override
        public String getName() {
            return "Do";
        }
    }
}

