/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sejda.model.pdf.label.PdfLabelNumberingStyle;
import org.sejda.model.pdf.label.PdfPageLabel;
import org.sejda.sambox.pdmodel.common.PDPageLabelRange;
import org.sejda.sambox.pdmodel.common.PDPageLabels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageLabelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PageLabelUtils.class);
    private static final Map<PdfLabelNumberingStyle, String> PAGE_NUMBERS_STYLES;

    private PageLabelUtils() {
    }

    public static PDPageLabels getLabels(Map<Integer, PdfPageLabel> labels, int totalPages) {
        PDPageLabels retLabels = new PDPageLabels();
        for (Map.Entry<Integer, PdfPageLabel> entry : labels.entrySet()) {
            int page = entry.getKey();
            if (page > 0 && page <= totalPages) {
                PdfPageLabel label = entry.getValue();
                PDPageLabelRange range = new PDPageLabelRange();
                range.setStyle(PAGE_NUMBERS_STYLES.get(label.getNumberingStyle()));
                range.setStart(label.getLogicalPageNumber());
                range.setPrefix(label.getLabelPrefix());
                retLabels.setLabelItem(page - 1, range);
                continue;
            }
            LOG.warn("Page number {} out of rage, {} will be ignored.", (Object)page, (Object)entry.getValue());
        }
        return retLabels;
    }

    static {
        HashMap<PdfLabelNumberingStyle, String> pageNumberStyles = new HashMap<PdfLabelNumberingStyle, String>();
        pageNumberStyles.put(PdfLabelNumberingStyle.ARABIC, "D");
        pageNumberStyles.put(PdfLabelNumberingStyle.LOWERCASE_LETTERS, "a");
        pageNumberStyles.put(PdfLabelNumberingStyle.LOWERCASE_ROMANS, "r");
        pageNumberStyles.put(PdfLabelNumberingStyle.UPPERCASE_LETTERS, "A");
        pageNumberStyles.put(PdfLabelNumberingStyle.UPPERCASE_ROMANS, "R");
        PAGE_NUMBERS_STYLES = Collections.unmodifiableMap(pageNumberStyles);
    }
}

