/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import org.sejda.sambox.encryption.GeneralEncryptionAlgorithm;
import org.sejda.sambox.encryption.StandardSecurity;
import org.sejda.util.RequireUtils;

public final class EncryptionContext {
    public final StandardSecurity security;
    private byte[] documentId;
    private byte[] key;

    public EncryptionContext(StandardSecurity security) {
        RequireUtils.requireNotNullArg(security, "Cannot create an encryption context with a null security");
        this.security = security;
    }

    public void documentId(byte[] documentId) {
        this.documentId = documentId;
    }

    byte[] documentId() {
        return this.documentId;
    }

    void key(byte[] key) {
        this.key = key;
    }

    byte[] key() {
        return this.key;
    }

    public GeneralEncryptionAlgorithm encryptionAlgorithm() {
        return this.security.encryption.encryptionAlgorithm(this);
    }
}

