/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDDocumentNameDestinationDictionary;
import org.sejda.sambox.pdmodel.PDDocumentNameDictionary;
import org.sejda.sambox.pdmodel.PDPageTree;
import org.sejda.sambox.pdmodel.PageLayout;
import org.sejda.sambox.pdmodel.PageMode;
import org.sejda.sambox.pdmodel.common.PDDestinationOrAction;
import org.sejda.sambox.pdmodel.common.PDMetadata;
import org.sejda.sambox.pdmodel.common.PDPageLabels;
import org.sejda.sambox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.sejda.sambox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.sejda.sambox.pdmodel.graphics.color.PDOutputIntent;
import org.sejda.sambox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.sejda.sambox.pdmodel.interactive.action.PDActionFactory;
import org.sejda.sambox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.sejda.sambox.pdmodel.interactive.action.PDURIDictionary;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDNamedDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.destination.PDPageDestination;
import org.sejda.sambox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.pagenavigation.PDThread;
import org.sejda.sambox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDDocumentCatalog
implements COSObjectable {
    private static final Logger LOG = LoggerFactory.getLogger(PDDocumentCatalog.class);
    private final COSDictionary root;
    private final PDDocument document;
    private PDAcroForm cachedAcroForm;

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, (COSBase)this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.root;
    }

    public PDAcroForm getAcroForm() {
        if (this.cachedAcroForm == null) {
            COSDictionary dict = this.root.getDictionaryObject(COSName.ACRO_FORM, COSDictionary.class);
            this.cachedAcroForm = dict == null ? null : new PDAcroForm(this.document, dict);
        }
        return this.cachedAcroForm;
    }

    public void setAcroForm(PDAcroForm acroForm) {
        this.root.setItem(COSName.ACRO_FORM, (COSObjectable)acroForm);
        this.cachedAcroForm = null;
    }

    public PDPageTree getPages() {
        return new PDPageTree((COSDictionary)this.root.getDictionaryObject(COSName.PAGES), this.document);
    }

    public PDViewerPreferences getViewerPreferences() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.VIEWER_PREFERENCES, COSDictionary.class)).map(PDViewerPreferences::new).orElse(null);
    }

    public void setViewerPreferences(PDViewerPreferences prefs) {
        this.root.setItem(COSName.VIEWER_PREFERENCES, (COSObjectable)prefs);
    }

    public PDDocumentOutline getDocumentOutline() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.OUTLINES, COSDictionary.class)).map(PDDocumentOutline::new).orElse(null);
    }

    public void setDocumentOutline(PDDocumentOutline outlines) {
        this.root.setItem(COSName.OUTLINES, (COSObjectable)outlines);
    }

    public List<PDThread> getThreads() {
        COSArray array = (COSArray)this.root.getDictionaryObject(COSName.THREADS);
        if (array == null) {
            array = new COSArray();
            this.root.setItem(COSName.THREADS, (COSBase)array);
        }
        ArrayList<PDThread> pdObjects = new ArrayList<PDThread>();
        for (int i = 0; i < array.size(); ++i) {
            pdObjects.add(new PDThread((COSDictionary)array.getObject(i)));
        }
        return new COSArrayList<PDThread>(pdObjects, array);
    }

    public void setThreads(List<PDThread> threads) {
        this.root.setItem(COSName.THREADS, (COSBase)COSArrayList.converterToCOSArray(threads));
    }

    public PDMetadata getMetadata() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.METADATA, COSStream.class)).map(PDMetadata::new).orElse(null);
    }

    public void setMetadata(PDMetadata meta) {
        this.root.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public void setOpenAction(PDDestinationOrAction action) {
        this.root.setItem(COSName.OPEN_ACTION, (COSObjectable)action);
    }

    public PDDestinationOrAction getOpenAction() throws IOException {
        COSBase openAction = this.root.getDictionaryObject(COSName.OPEN_ACTION);
        if (openAction == null) {
            return null;
        }
        if (openAction instanceof COSDictionary) {
            return PDActionFactory.createAction((COSDictionary)openAction);
        }
        if (openAction instanceof COSArray) {
            return PDDestination.create(openAction);
        }
        throw new IOException("Unknown OpenAction " + openAction);
    }

    public PDDocumentCatalogAdditionalActions getActions() {
        COSDictionary addAction = this.root.getDictionaryObject(COSName.AA, COSDictionary.class);
        if (addAction == null) {
            addAction = new COSDictionary();
            this.root.setItem(COSName.AA, (COSBase)addAction);
        }
        return new PDDocumentCatalogAdditionalActions(addAction);
    }

    public void setActions(PDDocumentCatalogAdditionalActions actions) {
        this.root.setItem(COSName.AA, (COSObjectable)actions);
    }

    public PDDocumentNameDictionary getNames() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.NAMES, COSDictionary.class)).map(PDDocumentNameDictionary::new).orElse(null);
    }

    public PDDocumentNameDestinationDictionary getDests() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.DESTS, COSDictionary.class)).map(PDDocumentNameDestinationDictionary::new).orElse(null);
    }

    public void setNames(PDDocumentNameDictionary names) {
        this.root.setItem(COSName.NAMES, (COSObjectable)names);
    }

    public PDMarkInfo getMarkInfo() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.MARK_INFO, COSDictionary.class)).map(PDMarkInfo::new).orElse(null);
    }

    public void setMarkInfo(PDMarkInfo markInfo) {
        this.root.setItem(COSName.MARK_INFO, (COSObjectable)markInfo);
    }

    public List<PDOutputIntent> getOutputIntents() {
        ArrayList<PDOutputIntent> retval = new ArrayList<PDOutputIntent>();
        COSArray array = this.root.getDictionaryObject(COSName.OUTPUT_INTENTS, COSArray.class);
        if (array != null) {
            for (COSBase cosBase : array) {
                PDOutputIntent oi = new PDOutputIntent((COSDictionary)cosBase.getCOSObject());
                retval.add(oi);
            }
        }
        return retval;
    }

    public void addOutputIntent(PDOutputIntent outputIntent) {
        COSArray array = this.root.getDictionaryObject(COSName.OUTPUT_INTENTS, COSArray.class);
        if (array == null) {
            array = new COSArray();
            this.root.setItem(COSName.OUTPUT_INTENTS, (COSBase)array);
        }
        array.add(outputIntent.getCOSObject());
    }

    public void setOutputIntents(List<PDOutputIntent> outputIntents) {
        COSArray array = new COSArray();
        for (PDOutputIntent intent : outputIntents) {
            array.add(intent.getCOSObject());
        }
        this.root.setItem(COSName.OUTPUT_INTENTS, (COSBase)array);
    }

    public PageMode getPageMode() {
        String mode = this.root.getNameAsString(COSName.PAGE_MODE);
        if (mode != null) {
            try {
                return PageMode.fromString(mode);
            }
            catch (IllegalArgumentException ex) {
                LOG.debug(String.format("Unrecognized page mode %s", mode));
            }
        }
        return PageMode.USE_NONE;
    }

    public void setPageMode(PageMode mode) {
        this.root.setName(COSName.PAGE_MODE, mode.stringValue());
    }

    public PageLayout getPageLayout() {
        String mode = this.root.getNameAsString(COSName.PAGE_LAYOUT);
        if (mode != null) {
            try {
                return PageLayout.fromString(mode);
            }
            catch (IllegalArgumentException ex) {
                LOG.debug(String.format("Unrecognized page layout %s", mode));
            }
        }
        return PageLayout.SINGLE_PAGE;
    }

    public void setPageLayout(PageLayout layout) {
        this.root.setName(COSName.PAGE_LAYOUT, layout.stringValue());
    }

    public PDURIDictionary getURI() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.URI, COSDictionary.class)).map(PDURIDictionary::new).orElse(null);
    }

    public void setURI(PDURIDictionary uri) {
        this.root.setItem(COSName.URI, (COSObjectable)uri);
    }

    public PDStructureTreeRoot getStructureTreeRoot() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.STRUCT_TREE_ROOT, COSDictionary.class)).map(PDStructureTreeRoot::new).orElse(null);
    }

    public void setStructureTreeRoot(PDStructureTreeRoot treeRoot) {
        this.root.setItem(COSName.STRUCT_TREE_ROOT, (COSObjectable)treeRoot);
    }

    public String getLanguage() {
        return this.root.getString(COSName.LANG);
    }

    public void setLanguage(String language) {
        this.root.setString(COSName.LANG, language);
    }

    public String getVersion() {
        return this.root.getNameAsString(COSName.VERSION);
    }

    public void setVersion(String version) {
        this.root.setName(COSName.VERSION, version);
    }

    public PDPageLabels getPageLabels() throws IOException {
        COSDictionary dict = (COSDictionary)this.root.getDictionaryObject(COSName.PAGE_LABELS);
        return dict == null ? null : new PDPageLabels(dict);
    }

    public void setPageLabels(PDPageLabels labels) {
        this.root.setItem(COSName.PAGE_LABELS, (COSObjectable)labels);
    }

    public PDOptionalContentProperties getOCProperties() {
        return Optional.ofNullable(this.root.getDictionaryObject(COSName.OCPROPERTIES, COSDictionary.class)).map(PDOptionalContentProperties::new).orElse(null);
    }

    public void setOCProperties(PDOptionalContentProperties ocProperties) {
        this.root.setItem(COSName.OCPROPERTIES, (COSObjectable)ocProperties);
        if (ocProperties != null) {
            this.document.requireMinVersion("1.5");
        }
    }

    public PDPageDestination findNamedDestinationPage(PDNamedDestination namedDest) throws IOException {
        PDDocumentNameDestinationDictionary nameDestDict;
        PDPageDestination namesDest = Optional.ofNullable(this.getNames()).map(PDDocumentNameDictionary::getDests).map(tree -> (PDPageDestination)tree.getValue(namedDest.getNamedDestination())).orElse(null);
        if (namesDest == null && (nameDestDict = this.getDests()) != null) {
            return (PDPageDestination)nameDestDict.getDestination(namedDest.getNamedDestination());
        }
        return namesDest;
    }
}

