/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.interactive.form;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSArrayList;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSInteger;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSNull;
import org.sejda.sambox.cos.COSObjectable;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.sejda.sambox.pdmodel.interactive.form.PDAcroForm;
import org.sejda.sambox.pdmodel.interactive.form.PDField;

public class PDNonTerminalField
extends PDField {
    public PDNonTerminalField(PDAcroForm acroForm) {
        super(acroForm);
    }

    PDNonTerminalField(PDAcroForm acroForm, COSDictionary field, PDNonTerminalField parent) {
        super(acroForm, field, parent);
    }

    @Override
    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getCOSObject().getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public List<PDField> getChildren() {
        ArrayList<PDField> children = new ArrayList<PDField>();
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            for (COSBase kid : kids) {
                if (COSNull.NULL.equals(kid) || !Objects.nonNull(kid)) continue;
                children.add(PDField.fromDictionary(this.getAcroForm(), (COSDictionary)kid.getCOSObject(), this));
            }
        }
        return children;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public void setChildren(List<PDField> children) {
        this.getCOSObject().setItem(COSName.KIDS, (COSBase)COSArrayList.converterToCOSArray(children));
    }

    public void addChild(PDField field) {
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            kids = new COSArray();
        }
        if (!kids.contains(field)) {
            kids.add(field);
            field.getCOSObject().setItem(COSName.PARENT, (COSObjectable)this);
            this.getCOSObject().setItem(COSName.KIDS, (COSBase)kids);
        }
    }

    public void removeChild(PDField field) {
        COSArray kids = (COSArray)this.getCOSObject().getDictionaryObject(COSName.KIDS);
        if (kids != null && kids.contains(field)) {
            kids.remove(field);
        }
    }

    @Override
    public String getFieldType() {
        return this.getCOSObject().getNameAsString(COSName.FT);
    }

    public COSBase getValue() {
        return this.getCOSObject().getDictionaryObject(COSName.V);
    }

    @Override
    public String getValueAsString() {
        return this.getCOSObject().getDictionaryObject(COSName.V).toString();
    }

    public void setValue(COSBase object) {
        this.getCOSObject().setItem(COSName.V, object);
    }

    @Override
    public void setValue(String value) {
        this.getCOSObject().setString(COSName.V, value);
    }

    public COSBase getDefaultValue() {
        return this.getCOSObject().getDictionaryObject(COSName.DV);
    }

    public void setDefaultValue(COSBase value) {
        this.getCOSObject().setItem(COSName.V, value);
    }

    @Override
    public List<PDAnnotationWidget> getWidgets() {
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminal() {
        return false;
    }
}

