/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;

public class ParserCSV {
    public static final char DEFAULT_SEPARATOR = ';';
    private char separator = (char)59;
    private String line = null;
    private int lastIndex = -1;

    public ParserCSV(String line, char separator) {
        if (line == null) {
            throw new IllegalArgumentException("<line> must not be null");
        }
        this.line = line;
        this.separator = separator;
    }

    public static String arrayToString(List items, char separator) {
        String serializedList = "";
        if (items == null) {
            return serializedList;
        }
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            serializedList = serializedList + iterator.next() + separator;
        }
        return serializedList;
    }

    public Integer getNextInteger() throws NumberFormatException {
        String s = this.getNextString();
        if (StringUtils.isNullOrEmpty(s)) {
            return null;
        }
        return Integer.valueOf(s);
    }

    public String getNextString() {
        String result = null;
        int to = this.line.indexOf(this.separator, this.lastIndex + 1);
        if (to > -1) {
            result = this.line.substring(this.lastIndex + 1, to);
            this.lastIndex = to;
        } else if (this.lastIndex < this.line.length() && this.lastIndex + 1 < this.line.length()) {
            result = this.line.substring(this.lastIndex + 1, this.line.length());
            this.lastIndex = this.line.length();
            Tracer.getInstance().developerWarning("Parser-content not terminated by expected separator");
        } else {
            return null;
        }
        return result.trim();
    }

    public Boolean getNextBoolean() {
        String value = this.getNextString();
        if (!StringUtils.isNullOrEmpty(value)) {
            if ((value = value.trim().toUpperCase()).equals("TRUE") || value.equals("YES") || value.equals("Y") || value.equals("1")) {
                return Boolean.TRUE;
            }
            if (value.equals("FALSE") || value.equals("NO") || value.equals("N") || value.equals("0")) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public static String maskSeparator(Object object, char sep) {
        if (object == null) {
            return "";
        }
        String text = null;
        char replacement = ',';
        text = object instanceof String ? (String)object : object.toString();
        text = text.replace('\n', replacement);
        if (sep == ';') {
            return text.replace(';', replacement);
        }
        Tracer.getInstance().developerWarning("non-default CSV-Separator <" + sep + "> not yet masked");
        return text;
    }

    public static List readFile(InputStream stream, char separator) {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader inFile = new BufferedReader(new InputStreamReader(stream));
        try {
            String line = "";
            while ((line = inFile.readLine()) != null) {
                if (line.indexOf(separator) < 0) continue;
                arrayList.add(line);
            }
            inFile.close();
        }
        catch (IOException e) {
            Tracer.getInstance().runtimeWarning("Could not read from Stream: " + e.toString());
        }
        return arrayList;
    }

    public void skip(int nrOfFields) {
        for (int i = 0; i < nrOfFields; ++i) {
            int to = this.line.indexOf(this.separator, this.lastIndex + 1);
            if (to <= -1) {
                Tracer.getInstance().runtimeWarning("no more separators after: " + i + "/" + nrOfFields);
                break;
            }
            this.lastIndex = to;
        }
    }

    public static List stringToArray(String serializedList, char separator) {
        if (StringUtils.isNullOrEmpty(serializedList)) {
            return new ArrayList();
        }
        ParserCSV parser = new ParserCSV(serializedList, separator);
        ArrayList<String> list = new ArrayList<String>();
        String item = parser.getNextString();
        while (item != null) {
            list.add(item);
            item = parser.getNextString();
        }
        return list;
    }

    public static void writeFile(PrintStream stream, JTable table, char separator) {
        int columnCount = table.getModel().getColumnCount();
        for (int col = 0; col < columnCount; ++col) {
            stream.print(table.getModel().getColumnName(col) + separator);
        }
        stream.println();
        int[] list = table.getSelectedRows();
        if (list.length == 0) {
            int rowCount = table.getModel().getRowCount();
            for (int row = 0; row < rowCount; ++row) {
                for (int col = 0; col < columnCount; ++col) {
                    Object value = table.getModel().getValueAt(row, col);
                    String field = StringUtils.getString(value);
                    field = ParserCSV.maskSeparator(field, separator);
                    stream.print(field + separator);
                }
                stream.println();
            }
        } else {
            for (int i = 0; i < list.length; ++i) {
                for (int col = 0; col < columnCount; ++col) {
                    Object value = table.getModel().getValueAt(list[i], col);
                    String field = StringUtils.getString(value);
                    field = ParserCSV.maskSeparator(field, separator);
                    stream.print(field + separator);
                }
                stream.println();
            }
        }
    }
}

