/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.iox.ilisite.IliRepository09.ModelName_;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata;
import ch.ehi.iox.ilisite.IliRepository09.RepositoryIndex.ModelMetadata_SchemaLanguage;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.gui.UserSettings;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class CheckReposIlis {
    public boolean checkRepoIlis(Configuration config, UserSettings settings) {
        Main.setHttpProxySystemProperties(settings);
        HashSet<IliFile> failedFiles = new HashSet<IliFile>();
        ArrayList<MetaEntryProblem> inconsistentMetaEntry = new ArrayList<MetaEntryProblem>();
        Iterator reposi = config.iteratorFileEntry();
        while (reposi.hasNext()) {
            IliFiles files;
            File ilimodelsFile;
            FileEntry e = (FileEntry)reposi.next();
            if (e.getKind() != 1) continue;
            String repos = e.getFilename();
            RepositoryAccess reposAccess = new RepositoryAccess();
            try {
                ilimodelsFile = reposAccess.getLocalFileLocation(repos, "ilimodels.xml", 0L, null);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError(e2);
                continue;
            }
            if (ilimodelsFile == null) {
                EhiLogger.logAdaption("URL <" + repos + "> contains no " + "ilimodels.xml" + "; ignored");
                continue;
            }
            ArrayList<ModelMetadata> modelMetadatav = RepositoryAccess.readIliModelsXml(ilimodelsFile);
            modelMetadatav = RepositoryAccess.getLatestVersions(modelMetadatav);
            try {
                files = RepositoryAccess.createIliFiles(repos, modelMetadatav);
            }
            catch (RepositoryAccessException e2) {
                EhiLogger.logError(e2);
                continue;
            }
            Iterator<IliFile> filei = files.iteratorFile();
            while (filei.hasNext()) {
                IliFile file = filei.next();
                ArrayList<String> ilimodels = new ArrayList<String>();
                Iterator modeli = file.iteratorModel();
                while (modeli.hasNext()) {
                    IliModel model = (IliModel)modeli.next();
                    ilimodels.add(model.getName());
                }
                Configuration fileconfig = new Configuration();
                try {
                    File iliFile = reposAccess.getLocalFileLocation(file.getRepositoryUri(), file.getPath(), 0L, file.getMd5());
                    if (iliFile == null) {
                        failedFiles.add(file);
                        continue;
                    }
                    fileconfig.addFileEntry(new FileEntry(iliFile.getPath(), 1));
                    fileconfig.setAutoCompleteModelList(true);
                    fileconfig.setGenerateWarnings(false);
                    TransferDescription td = Main.runCompiler(fileconfig, settings);
                    if (td == null) {
                        failedFiles.add(file);
                        continue;
                    }
                    String md5 = RepositoryAccess.calcMD5(iliFile);
                    for (Model model : td) {
                        if (model == td.INTERLIS || model.getFileName() == null || !model.getFileName().equals(iliFile.getAbsolutePath())) continue;
                        EhiLogger.logState("ckeck model " + model.getFileName());
                        ModelMetadata_SchemaLanguage csl = null;
                        if (model.getIliVersion().equals("1")) {
                            csl = ModelMetadata_SchemaLanguage.ili1;
                        } else if (model.getIliVersion().equals("2.2")) {
                            csl = ModelMetadata_SchemaLanguage.ili2_2;
                        } else if (model.getIliVersion().equals("2.3")) {
                            csl = ModelMetadata_SchemaLanguage.ili2_3;
                        } else {
                            if (model.getIliVersion().equals("2.4")) {
                                throw new IllegalStateException("unexpected ili version");
                            }
                            throw new IllegalStateException("unexpected ili version");
                        }
                        ModelMetadata modelMetadata = CheckReposIlis.getModelMetadata(modelMetadatav, model.getName(), csl);
                        if (modelMetadata == null) {
                            inconsistentMetaEntry.add(new MetaEntryProblem(null, model.getName(), "entry missing or wrong model name in ilimodels.xml for " + file.getPath()));
                            continue;
                        }
                        if (modelMetadata.getmd5() != null && !modelMetadata.getmd5().equalsIgnoreCase(md5)) {
                            inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getobjectoid(), model.getName(), "wrong md5 value; correct would be " + md5));
                        }
                        if (model.getIliVersion().equals("2.3")) {
                            if (modelMetadata.getVersion() != null && !modelMetadata.getVersion().equals(model.getModelVersion())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getobjectoid(), model.getName(), "wrong version value; correct would be " + model.getModelVersion()));
                            }
                            if (modelMetadata.getVersionComment() != null && !modelMetadata.getVersionComment().equals(model.getModelVersionExpl())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getobjectoid(), model.getName(), "wrong versionComment value; correct would be " + model.getModelVersionExpl()));
                            }
                            if (modelMetadata.getIssuer() != null && !modelMetadata.getIssuer().equals(model.getIssuer())) {
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getobjectoid(), model.getName(), "wrong issuer value; correct would be " + model.getIssuer()));
                            }
                        }
                        HashSet<String> depsMeta = new HashSet<String>();
                        HashSet<String> depsIli = new HashSet<String>();
                        for (ModelName_ dep : modelMetadata.getdependsOnModel()) {
                            depsMeta.add(dep.getvalue());
                        }
                        String sep = "";
                        StringBuilder missingDeps = new StringBuilder();
                        for (Model dep : model.getImporting()) {
                            String depIli = dep.getName();
                            depsIli.add(depIli);
                            if (depIli.equals("INTERLIS") || depsMeta.contains(depIli)) continue;
                            missingDeps.append(sep);
                            missingDeps.append(depIli);
                            sep = ",";
                        }
                        if (missingDeps.length() <= 0) continue;
                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getobjectoid(), model.getName(), "wrong depends list; misssing models " + missingDeps.toString()));
                    }
                }
                catch (RepositoryAccessException e1) {
                    EhiLogger.logError(e1);
                    failedFiles.add(file);
                }
            }
        }
        if (inconsistentMetaEntry.size() > 0) {
            Collections.sort(inconsistentMetaEntry, new Comparator<MetaEntryProblem>(){

                @Override
                public int compare(MetaEntryProblem arg0, MetaEntryProblem arg1) {
                    int c1 = arg0.getModelName().compareTo(arg1.getModelName());
                    if (c1 == 0) {
                        if (arg0.getTid() == null) {
                            if (arg1.getTid() == null) {
                                return 0;
                            }
                            return -1;
                        }
                        if (arg1.getTid() == null) {
                            return 1;
                        }
                        return arg0.getTid().compareTo(arg1.getTid());
                    }
                    return c1;
                }
            });
            for (MetaEntryProblem prb : inconsistentMetaEntry) {
                if (prb.getTid() == null) {
                    EhiLogger.logError(prb.getModelName() + ": " + prb.getMsg());
                    continue;
                }
                EhiLogger.logError(prb.getModelName() + "(TID=\"" + prb.getTid() + "\"): " + prb.getMsg());
            }
        }
        if (failedFiles.size() != 0) {
            StringBuilder failed = new StringBuilder();
            String sep = "";
            for (IliFile f : failedFiles) {
                failed.append(sep);
                failed.append(f.getPath());
                sep = ", ";
            }
            EhiLogger.logError("compile failed with files: " + failed);
        }
        return failedFiles.size() != 0;
    }

    private static ModelMetadata getModelMetadata(ArrayList<ModelMetadata> modelMetadatav, String name, ModelMetadata_SchemaLanguage csl) {
        for (ModelMetadata modelMetadata : modelMetadatav) {
            if (!modelMetadata.getName().equals(name) || !modelMetadata.getSchemaLanguage().equals(csl)) continue;
            return modelMetadata;
        }
        return null;
    }

    private class MetaEntryProblem {
        private String modelName = null;
        private String tid = null;
        private String msg = null;

        public MetaEntryProblem(String tid1, String modelName1, String msg1) {
            this.modelName = modelName1;
            this.tid = tid1;
            this.msg = msg1;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getTid() {
            return this.tid;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

