/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.brk.BreakpointMessageInterface;

public class BreakpointsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -8160051343126299124L;
    private static final int COLUMN_COUNT = 3;
    private static final String[] columnNames = new String[]{Constant.messages.getString("brk.table.header.enabled"), Constant.messages.getString("brk.table.header.type"), Constant.messages.getString("brk.table.header.condition")};
    private List<BreakpointMessageInterface> breakpoints = new ArrayList<BreakpointMessageInterface>(0);
    private List<BreakpointMessageInterface> breakpointsEnabled = new ArrayList<BreakpointMessageInterface>(0);
    private Map<BreakpointMessageInterface, Integer> mapBreakpointRow = new HashMap<BreakpointMessageInterface, Integer>();
    private int lastAffectedRow = -1;

    public List<BreakpointMessageInterface> getBreakpointsList() {
        return this.breakpoints;
    }

    public List<BreakpointMessageInterface> getBreakpointsEnabledList() {
        return this.breakpointsEnabled;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.breakpoints.size();
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        BreakpointMessageInterface breakpointMessageInterface = this.breakpoints.get(n);
        object = n2 == 0 ? Boolean.valueOf(breakpointMessageInterface.isEnabled()) : (n2 == 1 ? breakpointMessageInterface.getType() : breakpointMessageInterface.getDisplayMessage());
        return object;
    }

    public BreakpointMessageInterface getBreakpointAtRow(int n) {
        return this.breakpoints.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        this.breakpoints.add(breakpointMessageInterface);
        this.fireTableRowsInserted(this.breakpoints.size() - 1, this.breakpoints.size() - 1);
        this.rebuildMapBreakpointRow();
        this.lastAffectedRow = this.mapBreakpointRow.get(breakpointMessageInterface);
        if (breakpointMessageInterface.isEnabled()) {
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                this.breakpointsEnabled.add(breakpointMessageInterface);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editBreakpoint(BreakpointMessageInterface breakpointMessageInterface, BreakpointMessageInterface breakpointMessageInterface2) {
        int n = this.mapBreakpointRow.remove(breakpointMessageInterface);
        this.breakpoints.remove(n);
        this.fireTableRowsDeleted(n, n);
        this.mapBreakpointRow.put(breakpointMessageInterface2, 0);
        this.breakpoints.add(breakpointMessageInterface2);
        this.fireTableRowsInserted(this.breakpoints.size() - 1, this.breakpoints.size() - 1);
        this.rebuildMapBreakpointRow();
        this.lastAffectedRow = this.mapBreakpointRow.get(breakpointMessageInterface2);
        List<BreakpointMessageInterface> list = this.breakpointsEnabled;
        synchronized (list) {
            if (breakpointMessageInterface.isEnabled()) {
                this.breakpointsEnabled.remove(breakpointMessageInterface);
            }
            if (breakpointMessageInterface2.isEnabled()) {
                this.breakpointsEnabled.add(breakpointMessageInterface2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBreakpoint(BreakpointMessageInterface breakpointMessageInterface) {
        Integer n = this.mapBreakpointRow.remove(breakpointMessageInterface);
        if (n != null) {
            this.breakpoints.remove(breakpointMessageInterface);
            this.fireTableRowsDeleted(n, n);
            this.rebuildMapBreakpointRow();
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                if (breakpointMessageInterface.isEnabled()) {
                    this.breakpointsEnabled.remove(breakpointMessageInterface);
                }
            }
        }
    }

    public int getLastAffectedRow() {
        return this.lastAffectedRow;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Boolean) {
            boolean bl = this.breakpoints.get(n).isEnabled();
            this.breakpoints.get(n).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
            if (bl) {
                List<BreakpointMessageInterface> list = this.breakpointsEnabled;
                synchronized (list) {
                    this.breakpointsEnabled.remove(this.breakpoints.get(n));
                }
            }
            List<BreakpointMessageInterface> list = this.breakpointsEnabled;
            synchronized (list) {
                this.breakpointsEnabled.add(this.breakpoints.get(n));
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    private void rebuildMapBreakpointRow() {
        this.mapBreakpointRow.clear();
        int n = 0;
        Iterator<BreakpointMessageInterface> iterator = this.breakpoints.iterator();
        while (iterator.hasNext()) {
            this.mapBreakpointRow.put(iterator.next(), n);
            ++n;
        }
    }
}

