
#ifndef EOLIAN_CXX_STD_COMMENT_HH
#define EOLIAN_CXX_STD_COMMENT_HH

#include <string>
#include <sstream>
#include <iosfwd>
#include <ostream>

#include "tab.hh"

namespace efl { namespace eolian { namespace grammar {

using std::endl;

const std::string comment_prefix("///");

struct comment
{
   std::string _doc;
   int _tab;
   std::string _if_empty;
   comment(std::string const& doc, int tab = 0, std::string const& if_empty = "")
     : _doc(doc), _tab(tab), _if_empty(if_empty)
   {}
};

inline std::ostream&
operator<<(std::ostream& out, comment const& x)
{
   std::string const& doc = !x._doc.empty() ? x._doc : x._if_empty;
   std::istringstream ss(doc);
   std::string line;
   while(std::getline(ss, line))
     {
        out << tab(x._tab) << comment_prefix
            << (line.size() ? (" " + line) : "")
            << endl;
     }
   return out;
}

} } } // namespace efl { namespace eolian { namespace grammar {

#endif // EOLIAN_CXX_STD_COMMENT_HH
