/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AlgorithmParameters;
import java.security.CryptoPrimitive;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import sun.security.util.AbstractAlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;

public class LegacyAlgorithmConstraints
extends AbstractAlgorithmConstraints {
    public static final String PROPERTY_TLS_LEGACY_ALGS = "jdk.tls.legacyAlgorithms";
    private static final Map<String, String[]> legacyAlgorithmsMap = new HashMap<String, String[]>();
    private final String[] legacyAlgorithms;

    public LegacyAlgorithmConstraints(String propertyName, AlgorithmDecomposer decomposer) {
        super(decomposer);
        this.legacyAlgorithms = LegacyAlgorithmConstraints.getAlgorithms(legacyAlgorithmsMap, propertyName);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, AlgorithmParameters parameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, Key key) {
        return true;
    }

    @Override
    public final boolean permits(Set<CryptoPrimitive> primitives, String algorithm, Key key, AlgorithmParameters parameters) {
        return LegacyAlgorithmConstraints.checkAlgorithm(this.legacyAlgorithms, algorithm, this.decomposer);
    }
}

